package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

class CcseUpdateControlPlaneArgsApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsRequest request =
                new CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsRequest();
        request.setClusterId("");
        request.setRegionId("b342b77ef26b11ecb0ac0242ac110002");
        CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsKubeApiServerRequest request1 =
                new CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsKubeApiServerRequest();
        request1.setRequestTimeout("60s");
        request1.setMaxMutatingRequestsInflight("200");
        request1.setMaxRequestsInflight("400");
        request1.setDefaultNotReadyTolerationSeconds("300");
        request1.setDefaultUnreachableTolerationSeconds("300");
        request1.setEnableAdmissionPluginsNodeRestriction(false);
        request1.setEnableAdmissionPluginsPodNodeSelector(false);
        request1.setEnableAdmissionPluginsPodTolerationRestriction(false);
        request1.setApiAudiences("https://kubernetes.default.svc");
        request1.setServiceAccountIssuer("https://kubernetes.default.svc");
        request.setKubeApiServer(request1);
        CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsKubeControllerManagerRequest request2 =
                new CcseUpdateControlPlaneArgsApi
                        .UpdateControlPlaneArgsKubeControllerManagerRequest();
        request2.setKubeApiQps("20");
        request2.setKubeApiBurst("30");
        request2.setConcurrentDeploymentSyncs("5");
        request2.setConcurrentEndpointSyncs("5");
        request2.setConcurrentGcSyncs("20");
        request2.setConcurrentJobSyncs("5");
        request2.setConcurrentCronJobSyncs("5");
        request2.setConcurrentNamespaceSyncs("10");
        request2.setConcurrentReplicasetSyncs("5");
        request2.setConcurrentResourceQuotaSyncs("5");
        request2.setConcurrentServiceSyncs("1");
        request2.setConcurrentServiceaccountTokenSyncs("5");
        request2.setConcurrentTtlAfterFinishedSyncs("5");
        request2.setConcurrentHorizontalPodAutoscalerSyncs("5");
        request2.setUnhealthyZoneThreshold("0.55");
        request2.setSecondaryNodeEvictionRate("0.01");
        request2.setLargeClusterSizeThreshold("50");
        request2.setNodeEvictionRate("0.1");
        request2.setHorizontalPodAutoscalerSyncPeriod("15s");
        request2.setHorizontalPodAutoscalerTolerance("0.1");
        request2.setHorizontalPodAutoscalerCpuInitializationPeriod("300s");
        request2.setHorizontalPodAutoscalerInitialReadinessDelay("30s");
        request2.setTerminatedPodGcThreshold("12500");
        request2.setControllersResourceQuota(false);
        request.setKubeControllerManager(request2);
        CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsKubeSchedulerRequest request3 =
                new CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsKubeSchedulerRequest();
        request3.setKubeApiQps("50");
        request3.setKubeApiBurst("100");
        request.setKubeScheduler(request3);

        CcseUpdateControlPlaneArgsApi.UpdateControlPlaneArgsResponse response =
                apis.ccseUpdateControlPlaneArgsApi.send(credential, request);
        System.out.println(response);
    }
}
