package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CcseUpdateNodePoolApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        CcseUpdateNodePoolApi.UpdateNodePoolRequest request =
                new CcseUpdateNodePoolApi.UpdateNodePoolRequest();
        request.setClusterId("47281b02f87757478f20b1827c97cadf");
        request.setNodePoolId("3074a5bea28dec198475778f20b1827c");
        request.setRegionId("bb9fdb42056f11eda1610242ac110002");
        request.setNodePoolName("test");
        request.setEnableAutoScale(true);
        request.setMaxNum(9);
        request.setMinNum(0);
        request.setBillMode("1");
        request.setCycleCount(1);
        request.setCycleType("MONTH");
        request.setAutoRenewStatus(1);
        request.setSysDiskSize(120);
        request.setSysDiskType("SAS");
        CcseUpdateNodePoolApi.UpdateNodePoolDataDisksRequest request1 =
                new CcseUpdateNodePoolApi.UpdateNodePoolDataDisksRequest();
        request1.setSize(100);
        request1.setDiskSpecName("SAS");
        List<CcseUpdateNodePoolApi.UpdateNodePoolDataDisksRequest> request2 = new ArrayList<>();
        request2.add(request1);
        request.setDataDisks(request2);
        request.setSubnetUuid("subnet-7xipneei60");
        request.setVisibilityPostHostScript("");
        request.setVisibilityHostScript("");
        Map<String,String> request3 = new HashMap<>();
        request.setLabels(request3);
        Map<String,String> request4 = new HashMap<>();
        request.setAnnotations(request4);
        CcseUpdateNodePoolApi.UpdateNodePoolTaintsRequest request5 =
                new CcseUpdateNodePoolApi.UpdateNodePoolTaintsRequest();
        request5.setKey("");
        request5.setValue("");
        request5.setEffect("");
        List<CcseUpdateNodePoolApi.UpdateNodePoolTaintsRequest> request6 = new ArrayList<>();
        request6.add(request5);
        request.setTaints(request6);
        request.setSyncNodeLabels(false);
        request.setSyncNodeAnnotations(false);
        request.setSyncNodeTaints(false);
        request.setNodeUnschedulable(false);
        request.setIsSyncClusterResourceLabels(false);
        Map<String,String> request7 = new HashMap<>();
        request.setResourceLabels(request7);
        request.setAutoRepair(0);
        request.setDescription("");

        CcseUpdateNodePoolApi.UpdateNodePoolResponse response =
                apis.ccseUpdateNodePoolApi.send(credential, request);
        System.out.println(response);
    }
}
