package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

class CcseUpgradeNodePoolApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        CcseUpgradeNodePoolApi.UpgradeNodePoolRequest request =
                new CcseUpgradeNodePoolApi.UpgradeNodePoolRequest();
        request.setClusterId("47281b02f87757478f20b1827c97cadf");
        request.setNodePoolId("3074a5bea28dec198475778f20b1827c");
        request.setRegionId("bb9fdb42056f11eda1610242ac110002");
        request.setOsUpgrade(false);
        request.setUpgradeImageName("CTyunOS-xxx");
        request.setUpgradeImageID("49bb2582-23a2-42a7-be5e-2d1595f05267");
        request.setKubeletUpgrade(false);
        request.setUpgradeKubeletVersion("xxx");
        request.setRuntimeUpgrade(false);
        request.setRuntimeType("containerd");
        request.setUpgradeRuntimeVersion("xxx");

        CcseUpgradeNodePoolApi.UpgradeNodePoolResponse response =
                apis.ccseUpgradeNodePoolApi.send(credential, request);
        System.out.println(response);
    }
}
