#!/bin/bash
#
# telegraf     Startup script for the telegraf server agent
#
# chkconfig: 2345 80 30
# description: The plugin-driven server agent for reporting metrics into harvest.
#
### BEGIN INIT INFO
# Provides:       telegraf
# Required-Start: $local_fs $network
# Required-Stop:  $local_fs $network
# Default-Start:  2 3 4 5
# Default-Stop:   0 1 6
# Description:    The plugin-driven server agent for reporting metrics into harvest.
### END INIT INFO

PATH=/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/bin:/usr/local/sbin
NAME=telegraf
DAEMON=/usr/bin/$NAME
DAEMON_OPTS="-config /etc/telegraf/telegraf.conf -config-directory /etc/telegraf/telegraf.d $TELEGRAF_OPTS"
PIDFILE=/var/run/$NAME.pid

test -x $DAEMON || exit 0

. /etc/rc.d/init.d/functions

# Source networking configuration
. /etc/sysconfig/network

start() {
    echo -n $"Starting $NAME: "
    $DAEMON $DAEMON_OPTS > /dev/null 2>&1 &
    RETVAL=$?
    if [ $RETVAL -eq 0 ]; then
        pid=$!
        echo $pid > $PIDFILE
        touch /var/lock/subsys/$NAME
        success $"$NAME startup"
    else
        failure $"$NAME startup"
    fi
    echo
    return $RETVAL
}

stop() {
    echo -n $"Stopping $NAME: "
    killproc -p $PIDFILE $NAME
    RETVAL=$?
    echo
    if [ $RETVAL -eq 0 ]; then
        rm -f /var/lock/subsys/$NAME
        rm -f $PIDFILE
        success $"$NAME shutdown"
    else
        failure $"$NAME shutdown"
    fi
    echo
    return $RETVAL
}

case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    restart|force-reload)
        stop
        start
        ;;
    status)
        status -p $PIDFILE $NAME
        RETVAL=$?
        ;;
    *)
        echo $"Usage: $0 {start|stop|status|restart|force-reload}"
        exit 2
esac

exit $RETVAL
