﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace 安全组
{
    /// <summary>
    /// 按字典序排序
    /// </summary>
    public class DictionarySort : System.Collections.IComparer
    {
        public int Compare(object oLeft, object oRight)
        {
            string sLeft = oLeft as string;
            string sRight = oRight as string;
            int iLeftLength = sLeft.Length;
            int iRightLength = sRight.Length;
            int index = 0;
            while (index < iLeftLength && index < iRightLength)
            {
                if (sLeft[index] < sRight[index])
                    return -1;
                else if (sLeft[index] > sRight[index])
                    return 1;
                else
                    index++;
            }
            return iLeftLength - iRightLength;
        }
    }
    public class YunSign
    {

        private String url;
        private String body;
        private String ak;
        private String sk;
        private String uuId;

        public YunSign()
        {

        }

        public YunSign(String url, String ak, String sk, String uuId, String body)
        {
            this.url = url;
            this.body = body;
            this.ak = ak;
            this.sk = sk;
            this.uuId = uuId;
        }

        public String toDo(String method, string datetime)
        {
            String reuslt = "";

            method = method.ToUpper();
            switch (method)
            {
                //case "POST":
                //    reuslt = doPost(connectTimeout, connectionRequestTimeout, socketTimeout);
                //    break;
                case "GET":
                    reuslt = doGet(datetime);
                    break;
            }
            return reuslt;
        }
        /// <summary>
        /// SHA256加密
        /// </summary>
        /// <param name="text"></param>
        /// <returns></returns>
        private string getSHA256(string text)
        {
            try
            {
                using (SHA256 sha256 = SHA256.Create())
                {
                    byte[] bytes = Encoding.UTF8.GetBytes(text);
                    byte[] hash = sha256.ComputeHash(bytes);
                    return ToHex(hash);
                }
            }
            catch (System.Security.Cryptography.CryptographicException)
            {
                return null;
            }
        }
        //byte[] 转换为字符串
        private string ToHex(byte[] bytes)
        {
            StringBuilder sb = new StringBuilder();
            foreach (byte b in bytes)
            {
                sb.Append(b.ToString("x2"));
            }
            return sb.ToString();
        }
        /// <summary>
        /// 生成签名
        /// </summary>
        /// <param name="datetime"></param>
        /// <returns></returns>
        private String getSign(String datetime)
        {
            String calculateContentHash = getSHA256(body); //报文原封不动进行sha256摘要
            String singerDate = Convert.ToDateTime(datetime).ToString("yyyyMMdd'T'HHmmss'Z'");
            String singerDd = Convert.ToDateTime(datetime).ToString("yyyyMMdd");
            //header的key按照26字母进行排序, 以&作为连接符连起来
            try
            {
                Uri url = new Uri(this.url);
                String CampmocalHeader =String.Format("ctyun-eop-request-id:{0}\neop-date:{1}\n", this.uuId, singerDate);
                String query = url.Query;
                String afterQuery = "";
                if (query != null)
                {
                    query = query.Substring(1, query.Length-1);
                    String[] param = query.Split("&".ToArray());
                    Array.Sort(param, new DictionarySort());
                    foreach (String s in param)
                    {
                        //Query的参数值需要url编码，比如参数是 ID=1-32中文，需要将参数转换为 ID=1-32%e4%b8%ad%e6%96%87
                        string key = s.Substring(0, s.IndexOf("="));
                        string value = s.Substring(s.IndexOf("=") + 1, s.Length - s.IndexOf("=") - 1);

                        if (afterQuery.Length < 1)
                            afterQuery = afterQuery + key+"="+HttpUtility.UrlEncode(value);
                        else
                            afterQuery = afterQuery + "&" + key + "=" + HttpUtility.UrlEncode(value);
                    }
                }
                String sigture = CampmocalHeader + "\n" + afterQuery + "\n" + calculateContentHash;

                //这里的签名过程有4个步骤，注意HmacSHA256的 key--密钥 和 content--待加密字符串,每一个步骤的key都不一样  

                //1、用sk值作为key，将singerDate 进行HmacSHA256加密
                byte[] kheader = HmacSHA256(System.Text.Encoding.UTF8.GetBytes(sk),System.Text.Encoding.UTF8.GetBytes(singerDate));
                //2、将kheader作为key ,将ak值进行HmacSHA256加密
                byte[] kargs = HmacSHA256(kheader, System.Text.Encoding.UTF8.GetBytes(ak));
                //3、将kargs作为key ,将singerDd进行HmacSHA256加密
                byte[] kbody = HmacSHA256(kargs,System.Text.Encoding.UTF8.GetBytes(singerDd));


                //4、得到签名，将上一步的kbody 作为key，对参数 sigture 进行  
                String Signature = Convert.ToBase64String(HmacSHA256(kbody,System.Text.Encoding.UTF8.GetBytes(sigture)));

                String signHeader =String.Format("{0} Headers=ctyun-eop-request-id;eop-date Signature={1}", ak, Signature);
                return signHeader;
            }
            catch (Exception e)
            {
               
            }
            return null;
        }
        /// <summary>
        /// HmacSHA256算法,返回的结果始终是32位
        /// </summary>
        /// <param name="key">加密的键，可以是任何数据</param>
        /// <param name="content">待加密的内容</param>
        /// <returns></returns>
        public static byte[] HmacSHA256(byte[] key, byte[] content)
        {
            using (HMACSHA256 hmacsha256 = new HMACSHA256(key))
            {
                byte[] hashmessage = hmacsha256.ComputeHash(content);
                return hashmessage;
            }
        }
        /// <summary>
        /// GET方法
        /// </summary>
        /// <param name="datetime"></param>
        /// <returns></returns>
        public String doGet(string datetime)
        {
            String result = "";
            try
            {
                String eopdate =Convert.ToDateTime(datetime).ToString("yyyyMMdd'T'HHmmss'Z'");
                Uri uri = new Uri(this.url);
                String requesturl = this.url;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(requesturl);
                request.Method = "GET";
                if (this.body != "")
                {
                    byte[] bytes = Encoding.UTF8.GetBytes(this.body);
                    Stream reqstream = request.GetRequestStream();
                    reqstream.Write(bytes, 0, bytes.Length);
                }
                request.ContentType = "application/json; charset=utf-8";
                request.Headers.Add("ctyun-eop-request-id", this.uuId);
                request.Headers.Add("Eop-Authorization", getSign(datetime));
                request.Headers.Add("Eop-date", eopdate);
				request.Headers.Add("User-Agent", "Mozilla/5.0(netsdk)");
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream streamReceive = response.GetResponseStream();
                Encoding encoding = Encoding.UTF8;

                StreamReader streamReader = new StreamReader(streamReceive, encoding);
                result = streamReader.ReadToEnd();
                streamReceive.Dispose();
                streamReader.Dispose();
            }
            catch (WebException wex)
            {

                try
                {
                    WebResponse response = (WebResponse)wex.Response;
                    Stream backStream = response.GetResponseStream();
                    StreamReader sr = new StreamReader(backStream, Encoding.GetEncoding("UTF-8"));
                    result = sr.ReadToEnd();
                    sr.Close();
                    backStream.Close();
                    response.Close();
                    response.Dispose();
                }
                catch (Exception ex)
                {
                    result = "";
                }
            }
            return result;
        }
    }
}
