package apis

import (
	"ctyun-go-sdk/core"
)

const EndpointName = "ccse"

type Apis struct {
	CcseDeleteClusterPolicyInstanceApi           *CcseDeleteClusterPolicyInstanceApi
	CcseGetClusterPolicyStatusApi                *CcseGetClusterPolicyStatusApi
	CcseUpdateClusterPolicyInstanceApi           *CcseUpdateClusterPolicyInstanceApi
	CcseCreateClusterPolicyInstanceApi           *CcseCreateClusterPolicyInstanceApi
	CcseCheckControlPlaneLogEnabledApi           *CcseCheckControlPlaneLogEnabledApi
	CcseEnableControlPlaneLogApi                 *CcseEnableControlPlaneLogApi
	CcseGetClusterQuotaApi                       *CcseGetClusterQuotaApi
	CcseGetSubUserClusterKubeConfigApi           *CcseGetSubUserClusterKubeConfigApi
	CcseUpdateClusterKubeConfigExpirationTimeApi *CcseUpdateClusterKubeConfigExpirationTimeApi
	CcseGetSubUserClusterNamespacesApi           *CcseGetSubUserClusterNamespacesApi
	CcseGetKubernetesVersionsApi                 *CcseGetKubernetesVersionsApi
	CcseListClustersApi                          *CcseListClustersApi
	CcseListClusterNodesApi                      *CcseListClusterNodesApi
	CcsePauseClusterTaskApi                      *CcsePauseClusterTaskApi
	CcseResumeClusterTaskApi                     *CcseResumeClusterTaskApi
	CcseCancelClusterTaskApi                     *CcseCancelClusterTaskApi
	CcseHasPluginInstanceExistedApi              *CcseHasPluginInstanceExistedApi
	CcseListPluginInstancesApi                   *CcseListPluginInstancesApi
	CcseHasTemplateInstanceExistedApi            *CcseHasTemplateInstanceExistedApi
	CcseListDeploymentsApi                       *CcseListDeploymentsApi
	CcseListStatefulSetsApi                      *CcseListStatefulSetsApi
	CcseGetStatefulSetApi                        *CcseGetStatefulSetApi
	CcseUpdateStatefulSetApi                     *CcseUpdateStatefulSetApi
	CcseDeleteStatefulSetApi                     *CcseDeleteStatefulSetApi
	CcseCreateClusterApi                         *CcseCreateClusterApi
	CcseGetClusterKubeConfigApi                  *CcseGetClusterKubeConfigApi
	CcseRenewClusterApi                          *CcseRenewClusterApi
	CcseDeleteClusterApi                         *CcseDeleteClusterApi
	CcseCreateClusterDelegateApi                 *CcseCreateClusterDelegateApi
	CcseDeployPluginInstanceApi                  *CcseDeployPluginInstanceApi
	CcseRedeployPluginInstanceApi                *CcseRedeployPluginInstanceApi
	CcseGetPluginInstanceApi                     *CcseGetPluginInstanceApi
	CcseUpgradePluginInstanceApi                 *CcseUpgradePluginInstanceApi
	CcseDeletePluginInstanceApi                  *CcseDeletePluginInstanceApi
	CcseDeployTemplateInstanceApi                *CcseDeployTemplateInstanceApi
	CcseGetTemplateInstanceApi                   *CcseGetTemplateInstanceApi
	CcseGetPolicyGovernanceApi                   *CcseGetPolicyGovernanceApi
	CcseListPolicyRulesApi                       *CcseListPolicyRulesApi
	CcseGetPolicyTemplateApi                     *CcseGetPolicyTemplateApi
	CcseListClusterPolicyInstancesApi            *CcseListClusterPolicyInstancesApi
	CcseCreateDeploymentApi                      *CcseCreateDeploymentApi
	CcseGetDeploymentApi                         *CcseGetDeploymentApi
	CcseUpdateDeploymentApi                      *CcseUpdateDeploymentApi
	CcseDeleteDeploymentApi                      *CcseDeleteDeploymentApi
	CcseCreateDaemonSetApi                       *CcseCreateDaemonSetApi
	CcseGetDaemonSetApi                          *CcseGetDaemonSetApi
	CcseListDaemonSetsApi                        *CcseListDaemonSetsApi
	CcseUpdateDaemonSetApi                       *CcseUpdateDaemonSetApi
	CcseGetClusterApi                            *CcseGetClusterApi
	CcseCreateStatefulSetApi                     *CcseCreateStatefulSetApi
	CcseDeleteDaemonSetApi                       *CcseDeleteDaemonSetApi
	CcseGetSubUserPermissionApi                  *CcseGetSubUserPermissionApi
	CcseUpdateSubUserPermissionsApi              *CcseUpdateSubUserPermissionsApi
	CcseGetUpgradeClusterStatusApi               *CcseGetUpgradeClusterStatusApi
	CcseListNodePoolsApi                         *CcseListNodePoolsApi
	CcseDeleteTemplateInstanceApi                *CcseDeleteTemplateInstanceApi
	CcseListClusterTasksApi                      *CcseListClusterTasksApi
	CcseGetClusterTaskApi                        *CcseGetClusterTaskApi
	CcseListClusterTaskEventsApi                 *CcseListClusterTaskEventsApi
	CcseGetClusterEventsApi                      *CcseGetClusterEventsApi
	CcseAttachClusterNodesApi                    *CcseAttachClusterNodesApi
	CcseListClusterTagsApi                       *CcseListClusterTagsApi
	CcseCreateJobApi                             *CcseCreateJobApi
	CcseDeleteJobApi                             *CcseDeleteJobApi
	CcseDeletePodApi                             *CcseDeletePodApi
	CcseCreateConfigMapApi                       *CcseCreateConfigMapApi
	CcseDeleteConfigMapApi                       *CcseDeleteConfigMapApi
	CcseCreateSecretApi                          *CcseCreateSecretApi
	CcseDeleteSecretApi                          *CcseDeleteSecretApi
	CcseCreateServiceApi                         *CcseCreateServiceApi
	CcseListServicesApi                          *CcseListServicesApi
	CcseGetServiceApi                            *CcseGetServiceApi
	CcseDeleteServiceApi                         *CcseDeleteServiceApi
	CcseListEventsApi                            *CcseListEventsApi
	CcseListJobsApi                              *CcseListJobsApi
	CcseGetJobApi                                *CcseGetJobApi
	CcseUpdateJobApi                             *CcseUpdateJobApi
	CcseGetPodApi                                *CcseGetPodApi
	CcseCreatePodApi                             *CcseCreatePodApi
	CcseUpdatePodApi                             *CcseUpdatePodApi
	CcseListPodApi                               *CcseListPodApi
	CcseListConfigMapsApi                        *CcseListConfigMapsApi
	CcseUpdateConfigMapApi                       *CcseUpdateConfigMapApi
	CcseGetConfigMapApi                          *CcseGetConfigMapApi
	CcseListSecretsApi                           *CcseListSecretsApi
	CcseUpdateSecretApi                          *CcseUpdateSecretApi
	CcseGetSecretApi                             *CcseGetSecretApi
	CcseUpdateServiceApi                         *CcseUpdateServiceApi
	CcseGetClusterResourcesApi                   *CcseGetClusterResourcesApi
	CcseUpgradeClusterApi                        *CcseUpgradeClusterApi
	CcseUpdateClusterTagsApi                     *CcseUpdateClusterTagsApi
	CcseUnbindClusterTagsApi                     *CcseUnbindClusterTagsApi
	CcseBindClusterTagsApi                       *CcseBindClusterTagsApi
	CcseClusterUpgradePrecheckApi                *CcseClusterUpgradePrecheckApi
	CcseCreateReplicaSetApi                      *CcseCreateReplicaSetApi
	CcseDeleteReplicaSetApi                      *CcseDeleteReplicaSetApi
	CcseUpdateReplicaSetApi                      *CcseUpdateReplicaSetApi
	CcseGetReplicaSetApi                         *CcseGetReplicaSetApi
	CcseListReplicaSetsApi                       *CcseListReplicaSetsApi
	CcseUpdatePersistentVolumeClaimApi           *CcseUpdatePersistentVolumeClaimApi
	CcseGetPersistentVolumeClaimApi              *CcseGetPersistentVolumeClaimApi
	CcseListPersistentVolumeClaimsApi            *CcseListPersistentVolumeClaimsApi
	CcseCreatePersistentVolumeClaimApi           *CcseCreatePersistentVolumeClaimApi
	CcseDeletePersistentVolumeClaimApi           *CcseDeletePersistentVolumeClaimApi
	CcseDeletePersistentVolumeApi                *CcseDeletePersistentVolumeApi
	CcseUpdatePersistentVolumeApi                *CcseUpdatePersistentVolumeApi
	CcseGetPersistentVolumeApi                   *CcseGetPersistentVolumeApi
	CcseListPersistentVolumesApi                 *CcseListPersistentVolumesApi
	CcseCreatePersistentVolumeApi                *CcseCreatePersistentVolumeApi
	CcseDeleteStorageClassApi                    *CcseDeleteStorageClassApi
	CcseGetStorageClassApi                       *CcseGetStorageClassApi
	CcseUpdateStorageClassApi                    *CcseUpdateStorageClassApi
	CcseListStorageClassesApi                    *CcseListStorageClassesApi
	CcseCreateStorageClassApi                    *CcseCreateStorageClassApi
	CcseListVolumeSnapshotClassesApi             *CcseListVolumeSnapshotClassesApi
	CcseDeleteVolumeSnapshotClassApi             *CcseDeleteVolumeSnapshotClassApi
	CcseUpdateVolumeSnapshotClassApi             *CcseUpdateVolumeSnapshotClassApi
	CcseGetVolumeSnapshotClassApi                *CcseGetVolumeSnapshotClassApi
	CcseCreateVolumeSnapshotClassApi             *CcseCreateVolumeSnapshotClassApi
	CcseListVolumeSnapshotsApi                   *CcseListVolumeSnapshotsApi
	CcseDeleteVolumeSnapshotApi                  *CcseDeleteVolumeSnapshotApi
	CcseUpdateVolumeSnapshotApi                  *CcseUpdateVolumeSnapshotApi
	CcseGetVolumeSnapshotApi                     *CcseGetVolumeSnapshotApi
	CcseCreateVolumeSnapshotApi                  *CcseCreateVolumeSnapshotApi
	CcseGetNodeDetailApi                         *CcseGetNodeDetailApi
	CcseListClusterAutoscalerPoliciesApi         *CcseListClusterAutoscalerPoliciesApi
	CcseGetClusterAutoscalerPolicyApi            *CcseGetClusterAutoscalerPolicyApi
	CcseDeleteClusterAutoscalerPolicyApi         *CcseDeleteClusterAutoscalerPolicyApi
	CcseUpdateClusterAutoscalerPolicyApi         *CcseUpdateClusterAutoscalerPolicyApi
	CcseCreateClusterAutoscalerPolicyApi         *CcseCreateClusterAutoscalerPolicyApi
	CcseGetHorizontalPodAutoscalerApi            *CcseGetHorizontalPodAutoscalerApi
	CcseModifyNodeApi                            *CcseModifyNodeApi
	CcseQueryNodeApi                             *CcseQueryNodeApi
	CcseUpdateHorizontalPodAutoscalerApi         *CcseUpdateHorizontalPodAutoscalerApi
	CcseRemoveHorizontalPodAutoscalerV2Api       *CcseRemoveHorizontalPodAutoscalerV2Api
	CcseListHorizontalPodAutoscalersApi          *CcseListHorizontalPodAutoscalersApi
	CcseCreateHorizontalPodAutoscalerApi         *CcseCreateHorizontalPodAutoscalerApi
	CcseDeleteCronHorizontalPodAutoscalerApi     *CcseDeleteCronHorizontalPodAutoscalerApi
	CcseUpdateCronHorizontalPodAutoscalerApi     *CcseUpdateCronHorizontalPodAutoscalerApi
	CcseGetCronHorizontalPodAutoscalerApi        *CcseGetCronHorizontalPodAutoscalerApi
	CcseListCronHorizontalPodAutoscalersApi      *CcseListCronHorizontalPodAutoscalersApi
	CcseCreateCronHorizontalPodAutoscalerApi     *CcseCreateCronHorizontalPodAutoscalerApi
	CcseListNodesApi                             *CcseListNodesApi
	CcseUpdateClusterApi                         *CcseUpdateClusterApi
	CcseQueryClusterSubUserApi                   *CcseQueryClusterSubUserApi
	CcseQueryClusterIdByOrderIdApi               *CcseQueryClusterIdByOrderIdApi
	CcseCreateNodePoolApi                        *CcseCreateNodePoolApi
	CcseGetNodePoolApi                           *CcseGetNodePoolApi
	CcseUpdateNodePoolApi                        *CcseUpdateNodePoolApi
	CcseSyncNodePoolApi                          *CcseSyncNodePoolApi
	CcseUpgradeNodePoolApi                       *CcseUpgradeNodePoolApi
	CcseScaleUpNodePoolApi                       *CcseScaleUpNodePoolApi
	CcseRepairNodePoolApi                        *CcseRepairNodePoolApi
	CcseDeleteNodePoolApi                        *CcseDeleteNodePoolApi
	CcseBatchDeleteNodePoolApi                   *CcseBatchDeleteNodePoolApi
	CcseScaleDownNodePoolApi                     *CcseScaleDownNodePoolApi
	CcseCreatedNodesV2Api                        *CcseCreatedNodesV2Api
	CcseRemoveNodeV2Api                          *CcseRemoveNodeV2Api
	CcseUpdateClusterDeleteProtectionApi         *CcseUpdateClusterDeleteProtectionApi
	CcseUpdateClusterSeriesApi                   *CcseUpdateClusterSeriesApi
	CcseGetClusterSeriesTaskApi                  *CcseGetClusterSeriesTaskApi
	CcseGetClusterTempKubeConfigApi              *CcseGetClusterTempKubeConfigApi
	CcseUpdateNodePoolKubeletConfigApi           *CcseUpdateNodePoolKubeletConfigApi
	CcseUpdateSeriesAutoScaleApi                 *CcseUpdateSeriesAutoScaleApi
	CcseGetClusterNetworkConfigApi               *CcseGetClusterNetworkConfigApi
	CcseCreateNamespaceV2P2Api                   *CcseCreateNamespaceV2P2Api
	CcseListNamespaceV2P2Api                     *CcseListNamespaceV2P2Api
	CcseGetNamespaceV2P2Api                      *CcseGetNamespaceV2P2Api
	CcseUpdateNamespaceV2P2Api                   *CcseUpdateNamespaceV2P2Api
	CcseDeleteNamespaceV2P2Api                   *CcseDeleteNamespaceV2P2Api
	CcseUpdateCronJobV2P2Api                     *CcseUpdateCronJobV2P2Api
	CcseGetCronJobV2P2Api                        *CcseGetCronJobV2P2Api
	CcseListCronJobV2P2Api                       *CcseListCronJobV2P2Api
	CcseCreateCronJobV2P2Api                     *CcseCreateCronJobV2P2Api
	CcseDeleteCronJobV2P2Api                     *CcseDeleteCronJobV2P2Api
	CcseGetClusterServiceCidrDetailApi           *CcseGetClusterServiceCidrDetailApi
	CcseCreateCRDApi                             *CcseCreateCRDApi
	CcseUpdateClusterServiceCidrApi              *CcseUpdateClusterServiceCidrApi
	CcseListCRDApi                               *CcseListCRDApi
	CcseDeleteClusterServiceCidrApi              *CcseDeleteClusterServiceCidrApi
	CcseCreateClusterServiceCidrApi              *CcseCreateClusterServiceCidrApi
	CcseGetClusterServiceCidrApi                 *CcseGetClusterServiceCidrApi
	CcseGetCRDApi                                *CcseGetCRDApi
	CcseUpdateCRDApi                             *CcseUpdateCRDApi
	CcseDeleteCRDApi                             *CcseDeleteCRDApi
	CcseCreateServiceAccountsApi                 *CcseCreateServiceAccountsApi
	CcseListServiceAccountV2P2Api                *CcseListServiceAccountV2P2Api
	CcseGetServiceAccountApi                     *CcseGetServiceAccountApi
	CcseUpdateServiceAccountApi                  *CcseUpdateServiceAccountApi
	CcseDeleteServiceAccountApi                  *CcseDeleteServiceAccountApi
	CcseCreateResourceQuotaV2P2Api               *CcseCreateResourceQuotaV2P2Api
	CcseListResourceQuotaV2P2Api                 *CcseListResourceQuotaV2P2Api
	CcseGetResourceQuotaV2P2Api                  *CcseGetResourceQuotaV2P2Api
	CcseUpdateResourceQuotaV2P2Api               *CcseUpdateResourceQuotaV2P2Api
	CcseDeleteResourceQuotaV2P2Api               *CcseDeleteResourceQuotaV2P2Api
	CcseGetControlPlaneArgsApi                   *CcseGetControlPlaneArgsApi
	CcseUpdateControlPlaneArgsApi                *CcseUpdateControlPlaneArgsApi
	CcseQueryInspectionJobApi                    *CcseQueryInspectionJobApi
	CcseQueryInspectionReportsApi                *CcseQueryInspectionReportsApi
	CcseQueryInspectionReportDetailApi           *CcseQueryInspectionReportDetailApi
	CcseDeleteInspectionReportApi                *CcseDeleteInspectionReportApi
	CcseCreateInspectionJobApi                   *CcseCreateInspectionJobApi
	CcseDeleteInspectionJobApi                   *CcseDeleteInspectionJobApi
	CcseExecuteInspectionApi                     *CcseExecuteInspectionApi
	CcseUnsubscribeClusterApi                    *CcseUnsubscribeClusterApi
	CcseGetPublicImageListApi                    *CcseGetPublicImageListApi
}

func NewApis(endpointUrl string, client *core.CtyunClient) *Apis {
	client.RegisterEndpoint(core.Endpoint{
		Name: EndpointName,
		Url:  endpointUrl,
	})
	return &Apis{
		CcseDeleteClusterPolicyInstanceApi:           NewCcseDeleteClusterPolicyInstanceApi(client),
		CcseGetClusterPolicyStatusApi:                NewCcseGetClusterPolicyStatusApi(client),
		CcseUpdateClusterPolicyInstanceApi:           NewCcseUpdateClusterPolicyInstanceApi(client),
		CcseCreateClusterPolicyInstanceApi:           NewCcseCreateClusterPolicyInstanceApi(client),
		CcseCheckControlPlaneLogEnabledApi:           NewCcseCheckControlPlaneLogEnabledApi(client),
		CcseEnableControlPlaneLogApi:                 NewCcseEnableControlPlaneLogApi(client),
		CcseGetClusterQuotaApi:                       NewCcseGetClusterQuotaApi(client),
		CcseGetSubUserClusterKubeConfigApi:           NewCcseGetSubUserClusterKubeConfigApi(client),
		CcseUpdateClusterKubeConfigExpirationTimeApi: NewCcseUpdateClusterKubeConfigExpirationTimeApi(client),
		CcseGetSubUserClusterNamespacesApi:           NewCcseGetSubUserClusterNamespacesApi(client),
		CcseGetKubernetesVersionsApi:                 NewCcseGetKubernetesVersionsApi(client),
		CcseListClustersApi:                          NewCcseListClustersApi(client),
		CcseListClusterNodesApi:                      NewCcseListClusterNodesApi(client),
		CcsePauseClusterTaskApi:                      NewCcsePauseClusterTaskApi(client),
		CcseResumeClusterTaskApi:                     NewCcseResumeClusterTaskApi(client),
		CcseCancelClusterTaskApi:                     NewCcseCancelClusterTaskApi(client),
		CcseHasPluginInstanceExistedApi:              NewCcseHasPluginInstanceExistedApi(client),
		CcseListPluginInstancesApi:                   NewCcseListPluginInstancesApi(client),
		CcseHasTemplateInstanceExistedApi:            NewCcseHasTemplateInstanceExistedApi(client),
		CcseListDeploymentsApi:                       NewCcseListDeploymentsApi(client),
		CcseListStatefulSetsApi:                      NewCcseListStatefulSetsApi(client),
		CcseGetStatefulSetApi:                        NewCcseGetStatefulSetApi(client),
		CcseUpdateStatefulSetApi:                     NewCcseUpdateStatefulSetApi(client),
		CcseDeleteStatefulSetApi:                     NewCcseDeleteStatefulSetApi(client),
		CcseCreateClusterApi:                         NewCcseCreateClusterApi(client),
		CcseGetClusterKubeConfigApi:                  NewCcseGetClusterKubeConfigApi(client),
		CcseRenewClusterApi:                          NewCcseRenewClusterApi(client),
		CcseDeleteClusterApi:                         NewCcseDeleteClusterApi(client),
		CcseCreateClusterDelegateApi:                 NewCcseCreateClusterDelegateApi(client),
		CcseDeployPluginInstanceApi:                  NewCcseDeployPluginInstanceApi(client),
		CcseRedeployPluginInstanceApi:                NewCcseRedeployPluginInstanceApi(client),
		CcseGetPluginInstanceApi:                     NewCcseGetPluginInstanceApi(client),
		CcseUpgradePluginInstanceApi:                 NewCcseUpgradePluginInstanceApi(client),
		CcseDeletePluginInstanceApi:                  NewCcseDeletePluginInstanceApi(client),
		CcseDeployTemplateInstanceApi:                NewCcseDeployTemplateInstanceApi(client),
		CcseGetTemplateInstanceApi:                   NewCcseGetTemplateInstanceApi(client),
		CcseGetPolicyGovernanceApi:                   NewCcseGetPolicyGovernanceApi(client),
		CcseListPolicyRulesApi:                       NewCcseListPolicyRulesApi(client),
		CcseGetPolicyTemplateApi:                     NewCcseGetPolicyTemplateApi(client),
		CcseListClusterPolicyInstancesApi:            NewCcseListClusterPolicyInstancesApi(client),
		CcseCreateDeploymentApi:                      NewCcseCreateDeploymentApi(client),
		CcseGetDeploymentApi:                         NewCcseGetDeploymentApi(client),
		CcseUpdateDeploymentApi:                      NewCcseUpdateDeploymentApi(client),
		CcseDeleteDeploymentApi:                      NewCcseDeleteDeploymentApi(client),
		CcseCreateDaemonSetApi:                       NewCcseCreateDaemonSetApi(client),
		CcseGetDaemonSetApi:                          NewCcseGetDaemonSetApi(client),
		CcseListDaemonSetsApi:                        NewCcseListDaemonSetsApi(client),
		CcseUpdateDaemonSetApi:                       NewCcseUpdateDaemonSetApi(client),
		CcseGetClusterApi:                            NewCcseGetClusterApi(client),
		CcseCreateStatefulSetApi:                     NewCcseCreateStatefulSetApi(client),
		CcseDeleteDaemonSetApi:                       NewCcseDeleteDaemonSetApi(client),
		CcseGetSubUserPermissionApi:                  NewCcseGetSubUserPermissionApi(client),
		CcseUpdateSubUserPermissionsApi:              NewCcseUpdateSubUserPermissionsApi(client),
		CcseGetUpgradeClusterStatusApi:               NewCcseGetUpgradeClusterStatusApi(client),
		CcseListNodePoolsApi:                         NewCcseListNodePoolsApi(client),
		CcseDeleteTemplateInstanceApi:                NewCcseDeleteTemplateInstanceApi(client),
		CcseListClusterTasksApi:                      NewCcseListClusterTasksApi(client),
		CcseGetClusterTaskApi:                        NewCcseGetClusterTaskApi(client),
		CcseListClusterTaskEventsApi:                 NewCcseListClusterTaskEventsApi(client),
		CcseGetClusterEventsApi:                      NewCcseGetClusterEventsApi(client),
		CcseAttachClusterNodesApi:                    NewCcseAttachClusterNodesApi(client),
		CcseListClusterTagsApi:                       NewCcseListClusterTagsApi(client),
		CcseCreateJobApi:                             NewCcseCreateJobApi(client),
		CcseDeleteJobApi:                             NewCcseDeleteJobApi(client),
		CcseDeletePodApi:                             NewCcseDeletePodApi(client),
		CcseCreateConfigMapApi:                       NewCcseCreateConfigMapApi(client),
		CcseDeleteConfigMapApi:                       NewCcseDeleteConfigMapApi(client),
		CcseCreateSecretApi:                          NewCcseCreateSecretApi(client),
		CcseDeleteSecretApi:                          NewCcseDeleteSecretApi(client),
		CcseCreateServiceApi:                         NewCcseCreateServiceApi(client),
		CcseListServicesApi:                          NewCcseListServicesApi(client),
		CcseGetServiceApi:                            NewCcseGetServiceApi(client),
		CcseDeleteServiceApi:                         NewCcseDeleteServiceApi(client),
		CcseListEventsApi:                            NewCcseListEventsApi(client),
		CcseListJobsApi:                              NewCcseListJobsApi(client),
		CcseGetJobApi:                                NewCcseGetJobApi(client),
		CcseUpdateJobApi:                             NewCcseUpdateJobApi(client),
		CcseGetPodApi:                                NewCcseGetPodApi(client),
		CcseCreatePodApi:                             NewCcseCreatePodApi(client),
		CcseUpdatePodApi:                             NewCcseUpdatePodApi(client),
		CcseListPodApi:                               NewCcseListPodApi(client),
		CcseListConfigMapsApi:                        NewCcseListConfigMapsApi(client),
		CcseUpdateConfigMapApi:                       NewCcseUpdateConfigMapApi(client),
		CcseGetConfigMapApi:                          NewCcseGetConfigMapApi(client),
		CcseListSecretsApi:                           NewCcseListSecretsApi(client),
		CcseUpdateSecretApi:                          NewCcseUpdateSecretApi(client),
		CcseGetSecretApi:                             NewCcseGetSecretApi(client),
		CcseUpdateServiceApi:                         NewCcseUpdateServiceApi(client),
		CcseGetClusterResourcesApi:                   NewCcseGetClusterResourcesApi(client),
		CcseUpgradeClusterApi:                        NewCcseUpgradeClusterApi(client),
		CcseUpdateClusterTagsApi:                     NewCcseUpdateClusterTagsApi(client),
		CcseUnbindClusterTagsApi:                     NewCcseUnbindClusterTagsApi(client),
		CcseBindClusterTagsApi:                       NewCcseBindClusterTagsApi(client),
		CcseClusterUpgradePrecheckApi:                NewCcseClusterUpgradePrecheckApi(client),
		CcseCreateReplicaSetApi:                      NewCcseCreateReplicaSetApi(client),
		CcseDeleteReplicaSetApi:                      NewCcseDeleteReplicaSetApi(client),
		CcseUpdateReplicaSetApi:                      NewCcseUpdateReplicaSetApi(client),
		CcseGetReplicaSetApi:                         NewCcseGetReplicaSetApi(client),
		CcseListReplicaSetsApi:                       NewCcseListReplicaSetsApi(client),
		CcseUpdatePersistentVolumeClaimApi:           NewCcseUpdatePersistentVolumeClaimApi(client),
		CcseGetPersistentVolumeClaimApi:              NewCcseGetPersistentVolumeClaimApi(client),
		CcseListPersistentVolumeClaimsApi:            NewCcseListPersistentVolumeClaimsApi(client),
		CcseCreatePersistentVolumeClaimApi:           NewCcseCreatePersistentVolumeClaimApi(client),
		CcseDeletePersistentVolumeClaimApi:           NewCcseDeletePersistentVolumeClaimApi(client),
		CcseDeletePersistentVolumeApi:                NewCcseDeletePersistentVolumeApi(client),
		CcseUpdatePersistentVolumeApi:                NewCcseUpdatePersistentVolumeApi(client),
		CcseGetPersistentVolumeApi:                   NewCcseGetPersistentVolumeApi(client),
		CcseListPersistentVolumesApi:                 NewCcseListPersistentVolumesApi(client),
		CcseCreatePersistentVolumeApi:                NewCcseCreatePersistentVolumeApi(client),
		CcseDeleteStorageClassApi:                    NewCcseDeleteStorageClassApi(client),
		CcseGetStorageClassApi:                       NewCcseGetStorageClassApi(client),
		CcseUpdateStorageClassApi:                    NewCcseUpdateStorageClassApi(client),
		CcseListStorageClassesApi:                    NewCcseListStorageClassesApi(client),
		CcseCreateStorageClassApi:                    NewCcseCreateStorageClassApi(client),
		CcseListVolumeSnapshotClassesApi:             NewCcseListVolumeSnapshotClassesApi(client),
		CcseDeleteVolumeSnapshotClassApi:             NewCcseDeleteVolumeSnapshotClassApi(client),
		CcseUpdateVolumeSnapshotClassApi:             NewCcseUpdateVolumeSnapshotClassApi(client),
		CcseGetVolumeSnapshotClassApi:                NewCcseGetVolumeSnapshotClassApi(client),
		CcseCreateVolumeSnapshotClassApi:             NewCcseCreateVolumeSnapshotClassApi(client),
		CcseListVolumeSnapshotsApi:                   NewCcseListVolumeSnapshotsApi(client),
		CcseDeleteVolumeSnapshotApi:                  NewCcseDeleteVolumeSnapshotApi(client),
		CcseUpdateVolumeSnapshotApi:                  NewCcseUpdateVolumeSnapshotApi(client),
		CcseGetVolumeSnapshotApi:                     NewCcseGetVolumeSnapshotApi(client),
		CcseCreateVolumeSnapshotApi:                  NewCcseCreateVolumeSnapshotApi(client),
		CcseGetNodeDetailApi:                         NewCcseGetNodeDetailApi(client),
		CcseListClusterAutoscalerPoliciesApi:         NewCcseListClusterAutoscalerPoliciesApi(client),
		CcseGetClusterAutoscalerPolicyApi:            NewCcseGetClusterAutoscalerPolicyApi(client),
		CcseDeleteClusterAutoscalerPolicyApi:         NewCcseDeleteClusterAutoscalerPolicyApi(client),
		CcseUpdateClusterAutoscalerPolicyApi:         NewCcseUpdateClusterAutoscalerPolicyApi(client),
		CcseCreateClusterAutoscalerPolicyApi:         NewCcseCreateClusterAutoscalerPolicyApi(client),
		CcseGetHorizontalPodAutoscalerApi:            NewCcseGetHorizontalPodAutoscalerApi(client),
		CcseModifyNodeApi:                            NewCcseModifyNodeApi(client),
		CcseQueryNodeApi:                             NewCcseQueryNodeApi(client),
		CcseUpdateHorizontalPodAutoscalerApi:         NewCcseUpdateHorizontalPodAutoscalerApi(client),
		CcseRemoveHorizontalPodAutoscalerV2Api:       NewCcseRemoveHorizontalPodAutoscalerV2Api(client),
		CcseListHorizontalPodAutoscalersApi:          NewCcseListHorizontalPodAutoscalersApi(client),
		CcseCreateHorizontalPodAutoscalerApi:         NewCcseCreateHorizontalPodAutoscalerApi(client),
		CcseDeleteCronHorizontalPodAutoscalerApi:     NewCcseDeleteCronHorizontalPodAutoscalerApi(client),
		CcseUpdateCronHorizontalPodAutoscalerApi:     NewCcseUpdateCronHorizontalPodAutoscalerApi(client),
		CcseGetCronHorizontalPodAutoscalerApi:        NewCcseGetCronHorizontalPodAutoscalerApi(client),
		CcseListCronHorizontalPodAutoscalersApi:      NewCcseListCronHorizontalPodAutoscalersApi(client),
		CcseCreateCronHorizontalPodAutoscalerApi:     NewCcseCreateCronHorizontalPodAutoscalerApi(client),
		CcseListNodesApi:                             NewCcseListNodesApi(client),
		CcseUpdateClusterApi:                         NewCcseUpdateClusterApi(client),
		CcseQueryClusterSubUserApi:                   NewCcseQueryClusterSubUserApi(client),
		CcseQueryClusterIdByOrderIdApi:               NewCcseQueryClusterIdByOrderIdApi(client),
		CcseCreateNodePoolApi:                        NewCcseCreateNodePoolApi(client),
		CcseGetNodePoolApi:                           NewCcseGetNodePoolApi(client),
		CcseUpdateNodePoolApi:                        NewCcseUpdateNodePoolApi(client),
		CcseSyncNodePoolApi:                          NewCcseSyncNodePoolApi(client),
		CcseUpgradeNodePoolApi:                       NewCcseUpgradeNodePoolApi(client),
		CcseScaleUpNodePoolApi:                       NewCcseScaleUpNodePoolApi(client),
		CcseRepairNodePoolApi:                        NewCcseRepairNodePoolApi(client),
		CcseDeleteNodePoolApi:                        NewCcseDeleteNodePoolApi(client),
		CcseBatchDeleteNodePoolApi:                   NewCcseBatchDeleteNodePoolApi(client),
		CcseScaleDownNodePoolApi:                     NewCcseScaleDownNodePoolApi(client),
		CcseCreatedNodesV2Api:                        NewCcseCreatedNodesV2Api(client),
		CcseRemoveNodeV2Api:                          NewCcseRemoveNodeV2Api(client),
		CcseUpdateClusterDeleteProtectionApi:         NewCcseUpdateClusterDeleteProtectionApi(client),
		CcseUpdateClusterSeriesApi:                   NewCcseUpdateClusterSeriesApi(client),
		CcseGetClusterSeriesTaskApi:                  NewCcseGetClusterSeriesTaskApi(client),
		CcseGetClusterTempKubeConfigApi:              NewCcseGetClusterTempKubeConfigApi(client),
		CcseUpdateNodePoolKubeletConfigApi:           NewCcseUpdateNodePoolKubeletConfigApi(client),
		CcseUpdateSeriesAutoScaleApi:                 NewCcseUpdateSeriesAutoScaleApi(client),
		CcseGetClusterNetworkConfigApi:               NewCcseGetClusterNetworkConfigApi(client),
		CcseCreateNamespaceV2P2Api:                   NewCcseCreateNamespaceV2P2Api(client),
		CcseListNamespaceV2P2Api:                     NewCcseListNamespaceV2P2Api(client),
		CcseGetNamespaceV2P2Api:                      NewCcseGetNamespaceV2P2Api(client),
		CcseUpdateNamespaceV2P2Api:                   NewCcseUpdateNamespaceV2P2Api(client),
		CcseDeleteNamespaceV2P2Api:                   NewCcseDeleteNamespaceV2P2Api(client),
		CcseUpdateCronJobV2P2Api:                     NewCcseUpdateCronJobV2P2Api(client),
		CcseGetCronJobV2P2Api:                        NewCcseGetCronJobV2P2Api(client),
		CcseListCronJobV2P2Api:                       NewCcseListCronJobV2P2Api(client),
		CcseCreateCronJobV2P2Api:                     NewCcseCreateCronJobV2P2Api(client),
		CcseDeleteCronJobV2P2Api:                     NewCcseDeleteCronJobV2P2Api(client),
		CcseGetClusterServiceCidrDetailApi:           NewCcseGetClusterServiceCidrDetailApi(client),
		CcseCreateCRDApi:                             NewCcseCreateCRDApi(client),
		CcseUpdateClusterServiceCidrApi:              NewCcseUpdateClusterServiceCidrApi(client),
		CcseListCRDApi:                               NewCcseListCRDApi(client),
		CcseDeleteClusterServiceCidrApi:              NewCcseDeleteClusterServiceCidrApi(client),
		CcseCreateClusterServiceCidrApi:              NewCcseCreateClusterServiceCidrApi(client),
		CcseGetClusterServiceCidrApi:                 NewCcseGetClusterServiceCidrApi(client),
		CcseGetCRDApi:                                NewCcseGetCRDApi(client),
		CcseUpdateCRDApi:                             NewCcseUpdateCRDApi(client),
		CcseDeleteCRDApi:                             NewCcseDeleteCRDApi(client),
		CcseCreateServiceAccountsApi:                 NewCcseCreateServiceAccountsApi(client),
		CcseListServiceAccountV2P2Api:                NewCcseListServiceAccountV2P2Api(client),
		CcseGetServiceAccountApi:                     NewCcseGetServiceAccountApi(client),
		CcseUpdateServiceAccountApi:                  NewCcseUpdateServiceAccountApi(client),
		CcseDeleteServiceAccountApi:                  NewCcseDeleteServiceAccountApi(client),
		CcseCreateResourceQuotaV2P2Api:               NewCcseCreateResourceQuotaV2P2Api(client),
		CcseListResourceQuotaV2P2Api:                 NewCcseListResourceQuotaV2P2Api(client),
		CcseGetResourceQuotaV2P2Api:                  NewCcseGetResourceQuotaV2P2Api(client),
		CcseUpdateResourceQuotaV2P2Api:               NewCcseUpdateResourceQuotaV2P2Api(client),
		CcseDeleteResourceQuotaV2P2Api:               NewCcseDeleteResourceQuotaV2P2Api(client),
		CcseGetControlPlaneArgsApi:                   NewCcseGetControlPlaneArgsApi(client),
		CcseUpdateControlPlaneArgsApi:                NewCcseUpdateControlPlaneArgsApi(client),
		CcseQueryInspectionJobApi:                    NewCcseQueryInspectionJobApi(client),
		CcseQueryInspectionReportsApi:                NewCcseQueryInspectionReportsApi(client),
		CcseQueryInspectionReportDetailApi:           NewCcseQueryInspectionReportDetailApi(client),
		CcseDeleteInspectionReportApi:                NewCcseDeleteInspectionReportApi(client),
		CcseCreateInspectionJobApi:                   NewCcseCreateInspectionJobApi(client),
		CcseDeleteInspectionJobApi:                   NewCcseDeleteInspectionJobApi(client),
		CcseExecuteInspectionApi:                     NewCcseExecuteInspectionApi(client),
		CcseUnsubscribeClusterApi:                    NewCcseUnsubscribeClusterApi(client),
		CcseGetPublicImageListApi:                    NewCcseGetPublicImageListApi(client),
	}
}
