package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseCreateClusterApi
/* 调用该接口创建Kubernetes集群
 */
type CcseCreateClusterApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseCreateClusterApi(client *core.CtyunClient) *CcseCreateClusterApi {
	return &CcseCreateClusterApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPost,
			UrlPath:      "/v2/cce/clusters/create",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseCreateClusterApi) Do(ctx context.Context, credential core.Credential, req *CcseCreateClusterRequest) (*CcseCreateClusterResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	_, err := ctReq.WriteJson(struct {
		*CcseCreateClusterRequest
		RegionId interface{} `json:"regionId,omitempty"`
	}{
		req, nil,
	}, a.template.ContentType)
	if err != nil {
		return nil, err
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseCreateClusterResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseCreateClusterRequest struct {
	RegionId string `json:"regionId,omitempty"` /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>
	*/
	ClusterBaseInfo *CcseCreateClusterClusterBaseInfoRequest `json:"clusterBaseInfo"` /*  集群基本信息  */
	MasterHost      *CcseCreateClusterMasterHostRequest      `json:"masterHost"`      /*  master节点基本信息，专有版必填，托管版时不传  */
	SlaveHost       *CcseCreateClusterSlaveHostRequest       `json:"slaveHost"`       /*  worker节点基本信息  */
}

type CcseCreateClusterClusterBaseInfoRequest struct {
	ClusterName   string `json:"clusterName,omitempty"`   /*  集群名字，不允许重复，名称长度4~40个字符，大小写字母开头，只能包含大小写字母、数字及分隔符(-)，大小写字母或数字结尾。  */
	ClusterAlias  string `json:"clusterAlias,omitempty"`  /*  集群显示名称  */
	ClusterSeries string `json:"clusterSeries,omitempty"` /*  集群系列，cce.standard-专有版，cce.managed-托管版，您可查看<a href="https://www.ctyun.cn/document/10083472/10892150">产品定义</a>选择  */
	ProjectId     string `json:"projectId,omitempty"`     /*  集群所属企业项目id，企业项目管理服务提供统一的云资源按企业项目管理，以及企业项目内的资源管理，成员管理。您可以通过查看<a href="https://www.ctyun.cn/document/10017248/10017961">创建企业项目</a>了解如何创建企业项目
	注：默认值为"0"  */
	BillMode        string `json:"billMode,omitempty"`       /*  计费模式：1为包周期，2为按需  */
	CycleType       string `json:"cycleType,omitempty"`      /*  订购周期类型：billMode=1时必填，3-月，5-1年，6-2年，7-3年  */
	CycleCnt        string `json:"cycleCnt,omitempty"`       /*  订购时长：billMode=1时必填，cycleType为3时，cycleCnt可选1-6；cycleType=5-7时，cycleCnt可选1  */
	AutoRenewStatus *bool  `json:"autoRenewStatus"`          /*  是否自动续订，默认false；按月购买，自动续订周期为1个月；按年购买，自动续订周期为1年。  */
	ClusterVersion  string `json:"clusterVersion,omitempty"` /*  集群版本1.23.3 ，1.25.6 ，1.27.8，1.29.3，1.31.6，您可查看<a href="https://www.ctyun.cn/document/10083472/10650447">集群版本说明</a>选择。
	注：默认支持最高及以下的三个版本，其他版本需申请白名单，例如最高为1.31.6，则默认支持1.31.6，1.29.3，1.27.8  */
	SeriesType  string `json:"seriesType,omitempty"`  /*  托管版集群规格，托管版集群必填，单实例-managedbase，多实例-managedpro。单/多实例指控制面是否高可用，生产环境建议使用多实例  */
	NodeScale   string `json:"nodeScale,omitempty"`   /*  托管版集群节点规模。当seriesType=managedbase时，选择节点规模，可选10；当seriesType=managedpro时，选择节点规模，可选为50，200，1000，2000  */
	ElbProdCode string `json:"elbProdCode,omitempty"` /*  ApiServer的ELB类型，standardI（标准I型） ,standardII（标准II型）, enhancedI（增强I型）, enhancedII（增强II型） , higherI（高阶I型）
	您可查看不同<a href="https://www.ctyun.cn/document/10026756/10032048">类型规格</a>的详细说明
	*/
	EnableApiServerEip *bool  `json:"enableApiServerEip"` /*  是否开启ApiServerEip，默认false，若开启将自动创建按需计费类型的eip。  */
	VpcUuid            string `json:"vpcUuid,omitempty"`  /*  虚拟私有云ID，vpc企业项目需跟集群企业项目相同。通过以下方式查询：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4814&data=94&vid=88">查询用户vpc列表</a>
	注：在多可用区类型资源池下，vpcID通常为“vpc-”开头，非多可用区类型资源池vpcID为uuid格式
	*/
	SubnetUuid string `json:"subnetUuid,omitempty"` /*  子网id，需属于所选vpc。您可以查看<a href="https://www.ctyun.cn/document/10026755/10098380">基本概念</a>来查找子网的相关定义
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&amp;api=8659&amp;data=94">查询子网列表</a>
	注：在多可用区类型资源池下，subnetID通常以“subnet-”开头，非多可用区类型资源池subnetID为uuid格式  */
	EnableSnat     *bool  `json:"enableSnat"`               /*  是否开启nat网关，默认false，若开启将自动创建按需计费类型的nat网关。  */
	NatGatewaySpec string `json:"natGatewaySpec,omitempty"` /*  enableSnat=true必填，nat网关规格：small，medium，large，xlarge，您可查看不同<a href="https://www.ctyun.cn/document/10026759/10043996">类型规格</a>的详细说明  */
	IpStackType    string `json:"ipStackType,omitempty"`    /*  ip栈类型，ipv4或dual。dual表示双栈，默认ipv4，网络插件为calico时不支持ipv6。您可以通过查看<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://www.ctyun.cn/document/10083472/10915742">搭建IPv4/IPv6双栈集群</a>了解详情
	 */
	AutoGenerateSecurityGroup *bool  `json:"autoGenerateSecurityGroup"`   /*  是否自动创建安全组，默认false。  */
	SecurityGroupUuid         string `json:"securityGroupUuid,omitempty"` /*  安全组id，需属于所选vpc，autoGenerateSecurityGroup=false必填，使用自定义安全组时，需要配置如下规则，参考<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://www.ctyun.cn/document/10083472/10915714">集群安全组规则配置</a>
	安全组id您可以查看<a href="https://www.ctyun.cn/document/10026755/10028520">安全组概述</a>了解安全组相关信息
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4817&data=94&vid=88">查询用户安全组列表</a>
	注：在多可用区类型资源池下，安全组ID通常以“sg-”开头，非多可用区类型资源池安全组ID为uuid格式  */
	NetworkPlugin string `json:"networkPlugin,omitempty"` /*  网络插件，可选calico和cubecni。您可查看<a href="https://www.ctyun.cn/document/10083472/10520760">容器网络插件说明</a>选择
	注：calico需要申请白名单  */
	Ipvlan            *bool    `json:"ipvlan"`            /*  基于IPVLAN做弹性网卡共享，主机镜像只有使用CtyunOS系统才能生效  */
	NetworkPolicy     *bool    `json:"networkPolicy"`     /*  提供基于策略的网络访问控制  */
	PodSubnetUuidList []string `json:"podSubnetUuidList"` /*  pod子网id列表，网络插件选择cubecni必传，需属于所选vpc。
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&amp;api=8659&amp;data=94">查询子网列表</a>
	*/
	PodCidr string `json:"podCidr,omitempty"` /*  pod网络cidr，使用cubecni作为网络插件时，podCidr不传。calico网络插件时必传。
	注：网络插件为calico时，podCidr与vpcCidr与serviceCidr不能重叠。  */
	ServiceCidr   string `json:"serviceCidr,omitempty"`   /*  服务cidr。网络插件为calico时，podCidr与vpcCidr与serviceCidr不能重叠。选择cubecni时，podCidr（vpcCidr）与serviceCidr不能重叠。  */
	ServiceCidrV6 string `json:"serviceCidrV6,omitempty"` /*  ipStackType=dual时必填，IPV6网段的掩码必须在112到120之间，如fc00::/112  */
	KubeProxy     string `json:"kubeProxy,omitempty"`     /*  kubeProxy类型：iptables或ipvs，您可查看<a href="https://www.ctyun.cn/document/10083472/10915725">iptables与IPVS如何选择</a>
	 */
	StartPort int64  `json:"startPort,omitempty"` /*  节点服务开始端口，可选范围30000-65535  */
	EndPort   int64  `json:"endPort,omitempty"`   /*  节点服务终止端口，可选范围30000-65535，startPort到endPort范围需大于20  */
	San       string `json:"san,omitempty"`       /*  自定义证书SAN，您可查看<a href="https://www.ctyun.cn/document/10083472/10915719">自定义集群APIServer证书SAN</a>
	 */
	CustomCAEnable       *bool                                               `json:"customCAEnable"`                 /*  是否开启集群CA，默认false  */
	CustomCA             string                                              `json:"customCA,omitempty"`             /*  集群CA  */
	ClusterDomain        string                                              `json:"clusterDomain,omitempty"`        /*  集群本地域名，集群创建完成后，暂无法修改，请慎重配置  */
	DeleteProtection     *bool                                               `json:"deleteProtection"`               /*  集群删除保护  */
	ClusterLabels        map[string]string                                   `json:"clusterLabels"`                  /*  集群标签  */
	ClusterDesc          string                                              `json:"clusterDesc,omitempty"`          /*  集群描述  */
	ServiceAccountIssuer string                                              `json:"serviceAccountIssuer,omitempty"` /*  服务账号令牌卷投影service-account-issuer，默认为https://kubernetes.default.svc  */
	ApiAudiences         string                                              `json:"apiAudiences,omitempty"`         /*  服务账号令牌卷投影api-audiences，默认为https://kubernetes.default.svc  */
	KubeletArgs          *CcseCreateClusterClusterBaseInfoKubeletArgsRequest `json:"kubeletArgs"`                    /*  Kubelet自定义参数  */
	Timezone             string                                              `json:"timezone,omitempty"`             /*  时区  */
	NodePool             string                                              `json:"nodePool,omitempty"`             /*  默认节点池名称，默认default  */
	AzInfos              []*CcseCreateClusterClusterBaseInfoAzInfosRequest   `json:"azInfos"`                        /*  可用区信息，包括可用区编码，该可用区下master节点数量。专有版时必填  */
	ContainerRuntime     string                                              `json:"containerRuntime,omitempty"`     /*  容器运行时,可选containerd、docker，您可查看<a href="https://www.ctyun.cn/document/10083472/10902208">容器运行时说明</a>
	 */
	LoginType string `json:"loginType,omitempty"` /*  主机登录方式，password：密码，secretPair：密钥对。默认为password  */
	Password  string `json:"password,omitempty"`  /*  主机密码，loginType=password时必填，loginType不填时，password随机生成。满足以下规则：
	物理机：用户密码，满足以下规则：长度在8～30个字符；
	必须包含大小写字母和（至少一个数字或者特殊字符）；
	特殊符号可选：()`~!@#$%&*_-+=\
	云主机：长度在8～30个字符；
	必须包含大写字母、小写字母、数字以及特殊符号中的三项；
	特殊符号可选：()`-!@#$%^&*_-+=｜{}[]:;'<>,.?/且不能以斜线号 / 开头；
	不能包含3个及以上连续字符；  */
	KeyPairId string `json:"keyPairId,omitempty"` /*  密钥对id，loginType=secretPair时必填。您可以查看密钥对来了解密钥对相关内容
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81">查询一个或多个密钥对</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81" target="_blank">创建一对SSH密钥对</a>
	*/
	KeyName string `json:"keyName,omitempty"` /*  密钥对名称，loginType=secretPair时必填。您可以查看密钥对来了解密钥对相关内容
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81">查询一个或多个密钥对</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81" target="_blank">创建一对SSH密钥对</a>
	*/
	EnableHostName         *bool             `json:"enableHostName"`              /*  自定义节点名称是否开启  */
	HostNamePrefix         string            `json:"hostNamePrefix,omitempty"`    /*  自定义节点名称前缀  */
	HostNamePostfix        string            `json:"hostNamePostfix,omitempty"`   /*  自定义节点名称后缀  */
	NodeUnschedulable      *bool             `json:"nodeUnschedulable"`           /*  节点不可调度  */
	NodeLabels             map[string]string `json:"nodeLabels"`                  /*  节点标签  */
	NodeTaints             string            `json:"nodeTaints,omitempty"`        /*  节点污点，格式为 [{\"key\":\"{key}\",\"value\":\"{value}\",\"effect\":\"{effect}\"}]，上述的{key}、{value}、{effect}替换为所需字段。effect枚举包括NoSchedule、PreferNoSchedule、NoExecute  */
	ResourceLabels         map[string]string `json:"resourceLabels"`              /*  云主机资源标签  */
	SyncNodeLabels         *bool             `json:"syncNodeLabels"`              /*  节点池节点标签的改动将会被同步更新到存量节点，默认false  */
	SyncNodeTaints         *bool             `json:"syncNodeTaints"`              /*  节点池节点污点的改动将会被同步更新到存量节点，默认false  */
	CpuManagerPolicyEnable *bool             `json:"cpuManagerPolicyEnable"`      /*  是否开启cpu管理策略，默认false  */
	CustomScriptBase64     *bool             `json:"customScriptBase64"`          /*  节点自定义脚本是否采用base64编码，默认为false  */
	HostScript             string            `json:"hostScript,omitempty"`        /*  节点自定义脚本，如果customScriptBase64=false，此参数传明文；若customScriptBase64=true，此参数传base64后内容  */
	EnablePostUserScript   *bool             `json:"enablePostUserScript"`        /*  节点部署后置脚本是否采用base64编码  */
	PostUserScript         string            `json:"postUserScript,omitempty"`    /*  节点部署后置脚本，节点自定义脚本，如果enablePostUserScript=false，此参数传明文；若enablePostUserScript=true，此参数传base64后内容  */
	EnableAffinityGroup    *bool             `json:"enableAffinityGroup"`         /*  是否使用云主机组创建节点池，默认false；若enableAffinityGroup=false，表示不使用主机组；若enableAffinityGroup=true，affinityGroupUuid为空，表示使用默认反亲和主机组；若enableAffinityGroup=true，affinityGroupUuid不为空，表示使用已有主机组。该主机组配置仅对默认节点池生效，新建其他节点池可另外配置、  */
	AffinityGroupUuid      string            `json:"affinityGroupUuid,omitempty"` /*  是否使用已有反亲和性的云主机组创建节点池，enableAffinityGroup=true时填写，不填系统使用默认配置创建
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8324&data=87&vid=81">查询云主机组列表或者详情</a>  */
	DelegateName        string `json:"delegateName,omitempty"`       /*  工作节点使用已有委托，不填使用系统默认创建委托  */
	K8sNodeNameType     string `json:"k8sNodeNameType,omitempty"`    /*  节点池k8s节点名称类型，仅支持cceNodeName：与云主机保持一致  */
	InstallNginxIngress *bool  `json:"installNginxIngress"`          /*  是否安装nginx ingress插件  */
	NginxIngressLBSpec  string `json:"nginxIngressLBSpec,omitempty"` /*  installNginxIngress=true必填，nginx ingress ELB的规格:standardI（标准I型） ,standardII（标准II型）, enhancedI（增强I型）, enhancedII（增强II型） , higherI（高阶I型）
	您可查看不同<a href="https://www.ctyun.cn/document/10026756/10032048">规格的详细说明</a>  */
	NginxIngressLBNetWork   string `json:"nginxIngressLBNetWork,omitempty"` /*  installNginxIngress=true必填，nginx ingress访问方式：external（公网），internal（内网），当选择公网时将自动创建eip额外产生eip相关费用  */
	InstallDnsCache         *bool  `json:"installDnsCache"`                 /*  是否安装NodeLocal DNSCache插件，默认为false  */
	InstallCubeEye          *bool  `json:"installCubeEye"`                  /*  是否安装集群巡检插件，默认为false  */
	EnableLts               *bool  `json:"enableLts"`                       /*  是否使用云日志服务。获得您的授权，以委托方式开通云日志服务，并自动为您安装 ctg-log-operator 插件以及创建 VPC 终端节点，以建立 CCE 集群与云日志服务的连接通道。  */
	LtsProjectName          string `json:"ltsProjectName,omitempty"`        /*  指定集群使用已有的云日志项目的项目名，enbaleLts需要设置为true，需与ltsProjectCode参数同时设置，获取：<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=169&api=16658&data=216&isNormal=1&vid=295">云日志服务-项目分页列表</a>。若不指定则会默认创建一个集群专用的日志项目。  */
	EnableContainerLog      *bool  `json:"enableContainerLog"`              /*  是否启用容器日志的采集，依赖云日志服务，enbaleLts需要设置为true。将创建容器日志的单元及采集规则，采集并上报集群所有命名空间的容器标准输出（cube-eventer、控制面pod、nginx-ingress-controller除外）到云日志服务（LTS）  */
	EnableEventLog          *bool  `json:"enableEventLog"`                  /*  是否启用事件日志的采集，依赖云日志服务，enbaleLts需要设置为true。将自动为您安装cube-eventer插件，该插件是k8s事件采集插件，从集群apiserver获取k8s事件，并发送到对应的接收器中；并创建容器日志的单元及采集规则，采集并上报k8s事件到云日志服务（LTS）  */
	EnableControlPlaneLog   *bool  `json:"enableControlPlaneLog"`           /*  是否启用控制面日志的采集，依赖云日志服务，enbaleLts需要设置为true。将创建集群控制面日志的单元及采集规则，采集并上报集群控制面日志到云日志服务（LTS）  */
	EnableAuditLog          *bool  `json:"enableAuditLog"`                  /*  是否启用Kubernetes审计日志的采集，依赖云日志服务，enbaleLts需要设置为true。将创建Kubernetes审计日志的单元及采集规则，采集并上报Kubernetes审计日志到云日志服务（LTS）  */
	EnableIngressLog        *bool  `json:"enableIngressLog"`                /*  是否启用启用Ingress日志的采集，依赖云日志服务，enbaleLts需要设置为true。将创建Ingress日志的单元、采集规则及日志仪表盘，采集并上报Ingress日志到云日志服务（LTS）  */
	NodePoolBillingMode     string `json:"nodePoolBillingMode,omitempty"`   /*  节点池计费模式，对节点池内节点生效，1为包周期，2为按需  */
	NodePoolCycleType       string `json:"nodePoolCycleType,omitempty"`     /*  节点池计费周期，对节点池内节点生效，nodePoolBillingMode为1必传，3-月，5-1年，6-2年，7-3年  */
	NodePoolCycleCount      int32  `json:"nodePoolCycleCount,omitempty"`    /*  节点池计费时长，对节点池内节点生效，nodePoolBillingMode=1时必填，nodePoolCycleType为3时，nodePoolCycleCount可选1-6；nodePoolCycleType=5-7时，nodePoolCycleCount可选1  */
	NodePoolAutoRenewStatus *bool  `json:"nodePoolAutoRenewStatus"`         /*  节点池是否支持自动续费，按月购买，自动续订周期为1个月；按年购买，自动续订周期为1年。  */
}

type CcseCreateClusterMasterHostRequest struct {
	ItemDefName string `json:"itemDefName,omitempty"` /*  实例规格名称，使用至少4C8G以上的规格，支持云主机
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8327&data=87&isNormal=1&vid=81">查询主机规格资源</a>  */
	SysDisk   *CcseCreateClusterMasterHostSysDiskRequest     `json:"sysDisk"`   /*  系统盘信息  */
	DataDisks []*CcseCreateClusterMasterHostDataDisksRequest `json:"dataDisks"` /*  数据盘信息  */
}

type CcseCreateClusterSlaveHostRequest struct {
	ItemDefName string `json:"itemDefName,omitempty"` /*  实例规格名称，使用至少4C8G以上的规格
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8327&data=87&isNormal=1&vid=81">查询主机规格资源</a>  */
	SysDisk         *CcseCreateClusterSlaveHostSysDiskRequest     `json:"sysDisk"`                   /*  系统盘信息，当itemDefName为裸金属规格时，需确认该裸金属是否支持系统盘云盘  */
	DataDisks       []*CcseCreateClusterSlaveHostDataDisksRequest `json:"dataDisks"`                 /*  数据盘信息，当itemDefName为裸金属规格时，需确认该裸金属是否支持数据盘云盘  */
	ForeignMirrorId string                                        `json:"foreignMirrorId,omitempty"` /*  镜像id，私有镜像必填，镜像CPU架构需跟规格匹配
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://www.ctyun.cn/document/10083472/11004475">节点规格和节点镜像</a>  */
	MirrorType int32 `json:"mirrorType,omitempty"` /*  镜像类型，0-私有，1-公共。
	您可查看<a href="https://www.ctyun.cn/document/10026730/10030151">镜像概述</a>  */
	MirrorName string                                      `json:"mirrorName,omitempty"` /*  镜像名称，公共镜像必填，镜像CPU架构需跟规格匹配。您可查看<a href="https://www.ctyun.cn/document/10083472/11004475">节点规格和节点镜像</a>  */
	AzInfos    []*CcseCreateClusterSlaveHostAzInfosRequest `json:"azInfos"`              /*  可用区信息，包括可用区编码，可用区worker节点数量  */
}

type CcseCreateClusterClusterBaseInfoClusterLabelsRequest struct{}

type CcseCreateClusterClusterBaseInfoKubeletArgsRequest struct {
	KubeAPIQPS           int32  `json:"kubeAPIQPS,omitempty"`           /*  kubeAPIQPS  */
	KubeAPIBurst         int32  `json:"kubeAPIBurst,omitempty"`         /*  请求至kube-apiserver的Burst配置  */
	MaxPods              int32  `json:"maxPods,omitempty"`              /*  kubelet管理的pod上限  */
	RegistryPullQPS      int32  `json:"registryPullQPS,omitempty"`      /*  每秒钟可以执行的镜像仓库拉取操作限值  */
	RegistryBurst        int32  `json:"registryBurst,omitempty"`        /*  突发性镜像拉取的上限值  */
	PodPidsLimit         int32  `json:"podPidsLimit,omitempty"`         /*  限制Pod中的进程数  */
	EventRecordQPS       int32  `json:"eventRecordQPS,omitempty"`       /*  事件创建QPS限制  */
	EventBurst           int32  `json:"eventBurst,omitempty"`           /*  事件创建的个数的突发峰值上限  */
	TopologyManagerScope string `json:"topologyManagerScope,omitempty"` /*   拓扑管理策略的资源对齐粒度  */
	CpuCFSQuota          *bool  `json:"cpuCFSQuota"`                    /*  是否为设置了CPU限制的容器实施CPU CFS配额约束,默认值为true  */
}

type CcseCreateClusterClusterBaseInfoAzInfosRequest struct {
	AzName string `json:"azName,omitempty"` /*  可用区编码查询：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87&vid=81">资源池可用区查询</a>  */
	Size int32 `json:"size,omitempty"` /*  该可用区节点数量  */
}

type CcseCreateClusterClusterBaseInfoNodeLabelsRequest struct{}

type CcseCreateClusterClusterBaseInfoResourceLabelsRequest struct{}

type CcseCreateClusterMasterHostSysDiskRequest struct {
	ItemDefName string `json:"itemDefName,omitempty"` /*  系统盘规格，云硬盘类型，取值范围：
	SATA：普通IO，
	SAS：高IO，
	SSD：超高IO
	您可以查看<a href="https://www.ctyun.cn/document/10027696/10162918">磁盘类型及性能介绍</a>磁盘类型相关信息  */
	Size int32 `json:"size,omitempty"` /*  系统盘大小，单位为G  */
}

type CcseCreateClusterMasterHostDataDisksRequest struct {
	ItemDefName string `json:"itemDefName,omitempty"` /*  数据盘规格名称，取值范围：
	SATA：普通IO，
	SAS：高IO，
	SSD：超高IO
	您可以查看<a href="https://www.ctyun.cn/document/10027696/10162918">磁盘类型及性能介绍</a>磁盘类型相关信息  */
	Size int32 `json:"size,omitempty"` /*  数据盘大小，单位为G。
	系统盘：
	1、裸金属：取值范围[100,2040]
	2、云主机：取值范围[镜像磁盘大小,2040]
	数据盘：取值范围[10,20000]  */
	DecTypeId string `json:"decTypeId,omitempty"` /*  专属存储池id，需用专属资源池权限
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=4&api=12772&data=113&isNormal=1&vid=106">查询存储池信息详情</a>  */
}

type CcseCreateClusterSlaveHostSysDiskRequest struct {
	ItemDefName string `json:"itemDefName,omitempty"` /*  系统盘规格，云硬盘类型，取值范围：
	SATA：普通IO，
	SAS：高IO，
	SSD：超高IO
	您可以查看<a href="https://www.ctyun.cn/document/10027696/10162918">磁盘类型及性能介绍</a>磁盘类型相关信息  */
	Size int32 `json:"size,omitempty"` /*  系统盘大小，单位为G  */
}

type CcseCreateClusterSlaveHostDataDisksRequest struct {
	ItemDefName string `json:"itemDefName,omitempty"` /*  数据盘规格名称，取值范围：
	SATA：普通IO，
	SAS：高IO，
	SSD：超高IO
	您可以查看<a href="https://www.ctyun.cn/document/10027696/10162918">磁盘类型及性能介绍</a>磁盘类型相关信息  */
	Size int32 `json:"size,omitempty"` /*  数据盘大小，单位为G。
	系统盘：
	1、裸金属：取值范围[100,2040]
	2、云主机：取值范围[镜像磁盘大小,2040]
	数据盘：取值范围[10,20000]  */
	DecTypeId string `json:"decTypeId,omitempty"` /*  专属存储池id，需用专属资源池权限
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=4&api=12772&data=113&isNormal=1&vid=106">查询存储池信息详情</a>  */
}

type CcseCreateClusterSlaveHostAzInfosRequest struct {
	AzName string `json:"azName,omitempty"` /*  可用区编码查询：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87&vid=81">资源池可用区查询</a>  */
	Size int32 `json:"size,omitempty"` /*  该可用区节点数量  */
}

type CcseCreateClusterResponse struct {
	StatusCode int32                               `json:"statusCode"` /*  状态码  */
	Message    string                              `json:"message"`    /*  提示信息  */
	Error      string                              `json:"error"`      /*  错误码  */
	ReturnObj  *CcseCreateClusterReturnObjResponse `json:"returnObj"`  /*  返回对象  */
}

type CcseCreateClusterReturnObjResponse struct {
	OrderId string `json:"orderId"` /*  订单id  */
	OrderNo string `json:"orderNo"` /*  订单编号  */
}
type CcseCreateClusterTaintsRequest struct {
	Key    string `json:"key,omitempty"`    /*  键  */
	Value  string `json:"value,omitempty"`  /*  值  */
	Effect string `json:"effect,omitempty"` /*  策略  */
}
