package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"encoding/json"
	"testing"
)

func TestCcseCreateClusterApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseCreateClusterApi

	// 构造请求
	var autoRenewStatus bool = false
	var enableApiServerEip bool = false
	var enableSnat bool = false
	var autoGenerateSecurityGroup bool = false
	var ipvlan bool = false
	var networkPolicy bool = false
	var customCAEnable bool = false
	var deleteProtection bool = false
	var enableHostName bool = false
	var nodeUnschedulable bool = false
	var syncNodeLabels bool = false
	var syncNodeTaints bool = false
	var cpuManagerPolicyEnable bool = false
	var customScriptBase64 bool = false
	var enablePostUserScript bool = false
	var enableAffinityGroup bool = false
	var installNginxIngress bool = false
	var installDnsCache bool = false
	var installCubeEye bool = false
	var enableLts bool = false
	var enableContainerLog bool = false
	var enableEventLog bool = false
	var enableControlPlaneLog bool = false
	var enableAuditLog bool = false
	var enableIngressLog bool = false
	var nodePoolAutoRenewStatus bool = false
	var cpuCFSQuota bool = true
	nodeTaints := []*CcseCreateClusterTaintsRequest{
		{
			Key:    "aaa",
			Value:  "bbb",
			Effect: "NoSchedule",
		},
	}
	taints, _ := json.Marshal(nodeTaints)
	request := &CcseCreateClusterRequest{
		RegionId: "b342b77ef26b11ecb0ac0242ac110002",
		ClusterBaseInfo: &CcseCreateClusterClusterBaseInfoRequest{
			ClusterName:               "test-123",
			ClusterAlias:              "cce-test",
			ClusterSeries:             "cce.standard",
			ProjectId:                 "0",
			BillMode:                  "1",
			CycleType:                 "3",
			CycleCnt:                  "1",
			AutoRenewStatus:           &autoRenewStatus,
			ClusterVersion:            "1.31.6",
			SeriesType:                "managedpro",
			NodeScale:                 "50",
			ElbProdCode:               "standardI",
			EnableApiServerEip:        &enableApiServerEip,
			VpcUuid:                   "vpc-vu2t769u81",
			SubnetUuid:                "subnet-7xipneei60",
			EnableSnat:                &enableSnat,
			NatGatewaySpec:            "small",
			IpStackType:               "ipv4",
			AutoGenerateSecurityGroup: &autoGenerateSecurityGroup,
			SecurityGroupUuid:         "sg-8judj901ou",
			NetworkPlugin:             "calico",
			Ipvlan:                    &ipvlan,
			NetworkPolicy:             &networkPolicy,
			PodSubnetUuidList:         []string{},
			PodCidr:                   "192.168.0.0/16",
			ServiceCidr:               "172.26.0.0/16",
			ServiceCidrV6:             "",
			KubeProxy:                 "iptables",
			StartPort:                 30000,
			EndPort:                   32767,
			San:                       "192.168.1.1",
			CustomCAEnable:            &customCAEnable,
			CustomCA:                  "",
			ClusterDomain:             "cluster.local",
			DeleteProtection:          &deleteProtection,
			ClusterLabels:             map[string]string{},
			ClusterDesc:               "",
			ServiceAccountIssuer:      "",
			ApiAudiences:              "",
			KubeletArgs: &CcseCreateClusterClusterBaseInfoKubeletArgsRequest{
				KubeAPIQPS:           50,
				KubeAPIBurst:         100,
				MaxPods:              110,
				RegistryPullQPS:      5,
				RegistryBurst:        10,
				PodPidsLimit:         -1,
				EventRecordQPS:       50,
				EventBurst:           100,
				TopologyManagerScope: "container",
				CpuCFSQuota:          &cpuCFSQuota,
			},
			Timezone: "Asia/Shanghai",
			NodePool: "",
			AzInfos: []*CcseCreateClusterClusterBaseInfoAzInfosRequest{
				{
					AzName: "cn-huabei2-tj1A-public-ctcloud",
					Size:   1,
				},
			},
			ContainerRuntime:        "containerd",
			LoginType:               "password",
			Password:                "",
			KeyPairId:               "ba425a97-9ad9-2d45-e21a-770d2ebeb477",
			KeyName:                 "KeyPair-a589",
			EnableHostName:          &enableHostName,
			HostNamePrefix:          "",
			HostNamePostfix:         "",
			NodeUnschedulable:       &nodeUnschedulable,
			NodeLabels:              map[string]string{},
			NodeTaints:              string(taints),
			ResourceLabels:          map[string]string{},
			SyncNodeLabels:          &syncNodeLabels,
			SyncNodeTaints:          &syncNodeTaints,
			CpuManagerPolicyEnable:  &cpuManagerPolicyEnable,
			CustomScriptBase64:      &customScriptBase64,
			HostScript:              "",
			EnablePostUserScript:    &enablePostUserScript,
			PostUserScript:          "",
			EnableAffinityGroup:     &enableAffinityGroup,
			AffinityGroupUuid:       "8c66ee54-f922-75a8-1e13-af1f682f15dc",
			DelegateName:            "ecsadmintrust",
			K8sNodeNameType:         "cceNodeName",
			InstallNginxIngress:     &installNginxIngress,
			NginxIngressLBSpec:      "",
			NginxIngressLBNetWork:   "internal",
			InstallDnsCache:         &installDnsCache,
			InstallCubeEye:          &installCubeEye,
			EnableLts:               &enableLts,
			LtsProjectName:          "xxxxx",
			EnableContainerLog:      &enableContainerLog,
			EnableEventLog:          &enableEventLog,
			EnableControlPlaneLog:   &enableControlPlaneLog,
			EnableAuditLog:          &enableAuditLog,
			EnableIngressLog:        &enableIngressLog,
			NodePoolBillingMode:     "1",
			NodePoolCycleType:       "3",
			NodePoolCycleCount:      1,
			NodePoolAutoRenewStatus: &nodePoolAutoRenewStatus,
		},
		MasterHost: &CcseCreateClusterMasterHostRequest{
			ItemDefName: "s6.xlarge.2",
			SysDisk: &CcseCreateClusterMasterHostSysDiskRequest{
				ItemDefName: "SATA",
				Size:        120,
			},
			DataDisks: []*CcseCreateClusterMasterHostDataDisksRequest{
				{
					ItemDefName: "SATA",
					Size:        120,
					DecTypeId:   "b0d48eaf-e164-4873-9b89-e3dc85c8bed0",
				},
			},
		},
		SlaveHost: &CcseCreateClusterSlaveHostRequest{
			ItemDefName: "s6.xlarge.2",
			SysDisk: &CcseCreateClusterSlaveHostSysDiskRequest{
				ItemDefName: "SATA",
				Size:        120,
			},
			DataDisks: []*CcseCreateClusterSlaveHostDataDisksRequest{
				{
					ItemDefName: "SATA",
					Size:        120,
					DecTypeId:   "b0d48eaf-e164-4873-9b89-e3dc85c8bed0",
				},
			},
			ForeignMirrorId: "49317128-641c-4a54-b0f1-a47992933413",
			MirrorType:      1,
			MirrorName:      "CTyunOS-23.01-CCND_CCSE_40_08-x86_64",
			AzInfos: []*CcseCreateClusterSlaveHostAzInfosRequest{
				{
					AzName: "cn-huabei2-tj1A-public-ctcloud",
					Size:   1,
				},
			},
		},
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
