package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseCreateInspectionJobApi
/* 调用该接口创建或更新集群的巡检任务
 */type CcseCreateInspectionJobApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseCreateInspectionJobApi(client *core.CtyunClient) *CcseCreateInspectionJobApi {
	return &CcseCreateInspectionJobApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPost,
			UrlPath:      "/v2/cce/clusters/{clusterId}/inspection/job",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseCreateInspectionJobApi) Do(ctx context.Context, credential core.Credential, req *CcseCreateInspectionJobRequest) (*CcseCreateInspectionJobResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	_, err := ctReq.WriteJson(struct {
		*CcseCreateInspectionJobRequest
		RegionId  interface{} `json:"regionId,omitempty"`
		ClusterId interface{} `json:"clusterId,omitempty"`
	}{
		req, nil, nil,
	}, a.template.ContentType)
	if err != nil {
		return nil, err
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseCreateInspectionJobResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseCreateInspectionJobRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	Period string `json:"period,omitempty"` /*  巡检任务Cron表达式，Cron 表达式通常由 5个字段组成，每个字段之间用空格隔开，格式如下：
	分 时 日 月 星期
	如示例中的 59 0 * * * 代表每天0点59分执行  */
}

type CcseCreateInspectionJobResponse struct {
	StatusCode int32  `json:"statusCode"` /*  响应状态码  */
	Message    string `json:"message"`    /*  响应信息  */
	ReturnObj  string `json:"returnObj"`  /*  响应对象  */
	Error      string `json:"error"`      /*  错误码，参见错误码说明  */
}
