package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseCreateNodePoolApi
/* 调用该接口新增节点池。
 */
type CcseCreateNodePoolApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseCreateNodePoolApi(client *core.CtyunClient) *CcseCreateNodePoolApi {
	return &CcseCreateNodePoolApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPost,
			UrlPath:      "/v2/cce/clusters/{clusterId}/nodepool",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseCreateNodePoolApi) Do(ctx context.Context, credential core.Credential, req *CcseCreateNodePoolRequest) (*CcseCreateNodePoolResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	_, err := ctReq.WriteJson(struct {
		*CcseCreateNodePoolRequest
		RegionId  interface{} `json:"regionId,omitempty"`
		ClusterId interface{} `json:"clusterId,omitempty"`
	}{
		req, nil, nil,
	}, a.template.ContentType)
	if err != nil {
		return nil, err
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseCreateNodePoolResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseCreateNodePoolRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	NodePoolName    string                             `json:"nodePoolName,omitempty"`    /*  节点池名称  */
	EnableAutoScale *bool                              `json:"enableAutoScale"`           /*  是否自动弹性伸缩  */
	MaxNum          int32                              `json:"maxNum,omitempty"`          /*  伸缩组最大数量  */
	MinNum          int32                              `json:"minNum,omitempty"`          /*  伸缩组最小数量  */
	BillMode        string                             `json:"billMode,omitempty"`        /*  计费模式： 1-包年包月 2-按需计费  */
	CycleCount      int32                              `json:"cycleCount,omitempty"`      /*  订购时长，billMode为1必传，cycleType为MONTH时，cycleCount为1表示订购1个月  */
	CycleType       string                             `json:"cycleType,omitempty"`       /*  订购周期类型 MONTH-月 YEAR-年，billMode为1必传  */
	AutoRenewStatus int32                              `json:"autoRenewStatus,omitempty"` /*  是否自动续订 0-否 1-是，默认为0  */
	AzInfo          []*CcseCreateNodePoolAzInfoRequest `json:"azInfo"`                    /*  可用区信息，包括可用区ID，可用区名称
	可用区名称获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87&vid=81" target="_blank">资源池可用区查询</a>  */
	ContainerRuntime string `json:"containerRuntime,omitempty"` /*  容器运行时,可选containerd，默认值是containerd，您可查看<a href="https://www.ctyun.cn/document/10083472/10902208"  target="_blank">容器运行时说明</a>  */
	VmSpecName       string `json:"vmSpecName,omitempty"`       /*  节点规格，使用至少4C8G以上的规格，获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8327&data=87&isNormal=1&vid=81" target="_blank">查询主机规格资源</a>
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=4574&data=97&isNormal=1&vid=91" target="_blank">查询物理机套餐</a>  */
	ImageType int32 `json:"imageType,omitempty"` /*  镜像类型，0-私有镜像，1-公有镜像。
	您可查看<a href="https://www.ctyun.cn/document/10026730/10030151" target="_blank">镜像概述</a>  */
	ImageName string `json:"imageName,omitempty"` /*  镜像名称，公有镜像必填，镜像CPU架构需跟规格匹配。您可查看<a href="https://www.ctyun.cn/document/10083472/11004475" target="_blank">节点规格和节点镜像</a>  */
	ImageUuid string `json:"imageUuid,omitempty"` /*  镜像ID，私有镜像必填，镜像CPU架构需跟规格匹配。您可以查看<a href="https://www.ctyun.cn/document/10083472/11004475" target="_blank">节点规格和节点镜像</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=23&amp;api=4765&amp;data=89" target="_blank">创建私有镜像（云主机系统盘）</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=23&amp;api=5230&amp;data=89" target="_blank">创建私有镜像（云主机数据盘）</a>
	注：同一镜像名称在不同资源池的镜像ID是不同的，调用前需确认镜像ID是否归属当前资源池  */
	LoginType string `json:"loginType,omitempty"` /*  主机登录方式： password：密码，secretPair：密钥对  */
	Password  string `json:"password,omitempty"`  /*  云主机或物理机，用户登录密码，如果loginType=password，这该项为必填项，满足以下规则：
	物理机：用户密码，满足以下规则：长度在8～30个字符；
	必须包含大小写字母和（至少一个数字或者特殊字符）；
	特殊符号可选：()`~!@#$%&*_-+=\
	云主机：长度在8～30个字符；
	必须包含大写字母、小写字母、数字以及特殊符号中的三项；
	特殊符号可选：()`-!@#$%^&*_-+=｜{}[]:;'<>,.?/且不能以斜线号 / 开头；
	不能包含3个及以上连续字符；
	创建节点池时password字段可选择加密，具体加密方法请参见<a href="https://www.ctyun.cn/document/10083472/11002096" target="_blank">password字段加密的方法</a>  */
	KeyName string `json:"keyName,omitempty"` /*  密钥对名称，如果loginType=secretPair，物理机该项为必填项，您可以查看密钥对来了解密钥对相关内容
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81" target="_blank">查询一个或多个密钥对</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81" target="_blank">创建一对SSH密钥对</a>  */
	KeyPairId string `json:"keyPairId,omitempty"` /*  密钥对ID，如果loginType=secretPair，弹性云主机该项为必填项。您可以查看密钥对来了解密钥对相关内容
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81">查询一个或多个密钥对</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81" target="_blank">创建一对SSH密钥对</a>  */
	SysDiskType string `json:"sysDiskType,omitempty"` /*  系统盘规格，云硬盘类型，取值范围：
	SATA：普通IO，
	SAS：高IO，
	SSD：超高IO
	您可以查看<a href="https://www.ctyun.cn/document/10027696/10162918">磁盘类型及性能介绍</a>磁盘类型相关信息  */
	SysDiskSize int32 `json:"sysDiskSize,omitempty"` /*  系统盘大小，单位是G
	系统盘取值范围：
	1、裸金属：取值范围[100,2040]
	2、云主机：取值范围[镜像磁盘大小,2040]  */
	SysDiskDecTypeId string `json:"sysDiskDecTypeId,omitempty"` /*  专属存储池ID，需用专属资源池权限
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=4&api=12772&data=113&isNormal=1&vid=106" target="_blank">查询存储池信息详情</a>  */
	DataDisks       []*CcseCreateNodePoolDataDisksRequest `json:"dataDisks"`                 /*  数据盘信息，当vmSpecName为裸金属规格时，需确认该裸金属是否支持数据盘云盘。同一云主机下最多可挂载7块数据盘  */
	SecurityGroupId string                                `json:"securityGroupId,omitempty"` /*  安全组ID，如果不填则保持和集群的一致
	安全组ID 您可以查看<a href="https://www.ctyun.cn/document/10026755/10028520" target="_blank">安全组概述</a>了解安全组相关信息
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4817&data=94&vid=88">查询用户安全组列表</a>
	注：在多可用区类型资源池下，安全组ID通常以“sg-”开头，非多可用区类型资源池安全组ID为uuid格式  */
	SubnetUuid string `json:"subnetUuid,omitempty"` /*  子网ID，如果不填则保持和集群的一致
	您可以查看<a href="https://www.ctyun.cn/document/10026755/10098380" target="_blank">基本概念</a>来查找子网的相关定义
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&amp;api=8659&amp;data=94" target="_blank">查询子网列表</a>
	注：在多可用区类型资源池下，subnetID通常以“subnet-”开头，非多可用区类型资源池subnetID为uuid格式  */
	DefinedHostnameEnable       int32                                 `json:"definedHostnameEnable,omitempty"`    /*  是否使用自定义节点名称；默认值0：不使用；1：使用  */
	HostNamePrefix              string                                `json:"hostNamePrefix,omitempty"`           /*  自定义节点名称前缀，长度不超过10  */
	HostNamePostfix             string                                `json:"hostNamePostfix,omitempty"`          /*  自定义节点名称后缀，长度不超过10  */
	VisibilityHostScript        string                                `json:"visibilityHostScript,omitempty"`     /*  部署前执行自定义脚本，base64编码  */
	VisibilityPostHostScript    string                                `json:"visibilityPostHostScript,omitempty"` /*  部署后执行自定义脚本，base64编码  */
	Labels                      map[string]string                     `json:"labels"`                             /*  K8S节点标签  */
	Annotations                 map[string]string                     `json:"annotations"`                        /*  K8S节点注解  */
	Taints                      []*CcseCreateNodePoolTaintsRequest    `json:"taints"`                             /*  节点污点，格式为 [{\"key\":\"{key}\",\"value\":\"{value}\",\"effect\":\"{effect}\"}]，上述的{key}、{value}、{effect}替换为所需字段。effect枚举包括NoSchedule、PreferNoSchedule、NoExecute  */
	SyncNodeLabels              *bool                                 `json:"syncNodeLabels"`                     /*  是否同步节点标签  */
	SyncNodeAnnotations         *bool                                 `json:"syncNodeAnnotations"`                /*  是否同步节点注解  */
	SyncNodeTaints              *bool                                 `json:"syncNodeTaints"`                     /*  是否同步节点污点  */
	KubeletArgs                 *CcseCreateNodePoolKubeletArgsRequest `json:"kubeletArgs"`                        /*  Kubelet自定义参数  */
	K8sNodeNameType             string                                `json:"k8sNodeNameType,omitempty"`          /*  K8S节点名称配置类型。目前仅支持：cceNodeName: 将CCE节点名称作为K8S节点名称  */
	NodeUnschedulable           *bool                                 `json:"nodeUnschedulable"`                  /*  节点是否不可调度  */
	IsSyncClusterResourceLabels *bool                                 `json:"isSyncClusterResourceLabels"`        /*  是否同步集群标签。默认是false。如果为true，则同步以当前集群标签为基准的快照。  */
	ResourceLabels              map[string]string                     `json:"resourceLabels"`                     /*  云主机资源标签  */
	KubeletDirectory            string                                `json:"kubeletDirectory,omitempty"`         /*  kubelet数据目录。该参数可以自定义指定在/data下的子目录，用于kubelet数据目录。该参数由白名单控制  */
	ContainerDataDirectory      string                                `json:"containerDataDirectory,omitempty"`   /*  容器数据目录。该参数可以自定义指定在/data下的子目录，用于容器数据目录。该参数由白名单控制  */
	UseAffinityGroup            *bool                                 `json:"useAffinityGroup"`                   /*  是否启用主机组  */
	AffinityGroupUuid           string                                `json:"affinityGroupUuid,omitempty"`        /*  云主机组ID，获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8324&data=87&vid=81" target="_blank">查询云主机组列表或者详情</a>
	<span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8316&data=87&vid=81" target="_blank">创建云主机组</a>  */
	AutoRepair  int32  `json:"autoRepair,omitempty"`  /*  托管版集群是否开启节点自愈。0：不开启，1：开启。默认值是0  */
	Description string `json:"description,omitempty"` /*  节点池描述，最长不超过100  */
}

type CcseCreateNodePoolAzInfoRequest struct {
	AzName string `json:"azName,omitempty"` /*  可用区名称  */
}

type CcseCreateNodePoolDataDisksRequest struct {
	Size         int32  `json:"size,omitempty"`         /*  数据盘大小，单位为G，取值范围[10,20000]  */
	DiskSpecName string `json:"diskSpecName,omitempty"` /*  数据盘规格名称，取值范围：
	SATA：普通IO，
	SAS：高IO，
	SSD：超高IO
	您可以查看<a href="https://www.ctyun.cn/document/10027696/10162918">磁盘类型及性能介绍</a>磁盘类型相关信息  */
	DecTypeId string `json:"decTypeId,omitempty"` /*  专属存储池ID，需用专属资源池权限
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=4&api=12772&data=113&isNormal=1&vid=106" target="_blank">查询存储池信息详情</a>  */
}

type CcseCreateNodePoolLabelsRequest struct{}

type CcseCreateNodePoolAnnotationsRequest struct{}

type CcseCreateNodePoolTaintsRequest struct {
	Key    string `json:"key,omitempty"`    /*  键  */
	Value  string `json:"value,omitempty"`  /*  值  */
	Effect string `json:"effect,omitempty"` /*  策略  */
}

type CcseCreateNodePoolKubeletArgsRequest struct {
	KubeAPIQPS           int32  `json:"kubeAPIQPS,omitempty"`           /*  请求至kube-apiserver的QPS配置  */
	KubeAPIBurst         int32  `json:"kubeAPIBurst,omitempty"`         /*  请求至kube-apiserver的Burst配置  */
	MaxPods              int32  `json:"maxPods,omitempty"`              /*  kubelet管理的pod上限  */
	RegistryPullQPS      int32  `json:"registryPullQPS,omitempty"`      /*  每秒钟可以执行的镜像仓库拉取操作限值  */
	RegistryBurst        int32  `json:"registryBurst,omitempty"`        /*  突发性镜像拉取的上限值  */
	PodPidsLimit         int32  `json:"podPidsLimit,omitempty"`         /*  限制Pod中的进程数  */
	EventRecordQPS       int32  `json:"eventRecordQPS,omitempty"`       /*  事件创建QPS限制  */
	EventBurst           int32  `json:"eventBurst,omitempty"`           /*  事件创建的个数的突发峰值上限  */
	TopologyManagerScope string `json:"topologyManagerScope,omitempty"` /*   拓扑管理策略的资源对齐粒度  */
	CpuCFSQuota          *bool  `json:"cpuCFSQuota"`                    /*  是否为设置了CPU限制的容器实施CPU CFS配额约束,默认值为true  */
}

type CcseCreateNodePoolResourceLabelsRequest struct{}

type CcseCreateNodePoolResponse struct {
	StatusCode int32  `json:"statusCode"` /*  状态码  */
	RequestId  string `json:"requestId"`  /*  请求ID  */
	Message    string `json:"message"`    /*  提示信息  */
	ReturnObj  *bool  `json:"returnObj"`  /*  返回对象  */
	Error      string `json:"error"`      /*  错误码  */
}
