package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseCreateNodePoolApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseCreateNodePoolApi

	// 构造请求
	var enableAutoScale bool = true
	var syncNodeLabels bool = false
	var syncNodeAnnotations bool = false
	var syncNodeTaints bool = false
	var nodeUnschedulable bool = false
	var isSyncClusterResourceLabels bool = false
	var useAffinityGroup bool = false
	var cpuCFSQuota bool = true
	request := &CcseCreateNodePoolRequest{
		ClusterId:       "47281b02f87757478f20b1827c97cadf",
		RegionId:        "bb9fdb42056f11eda1610242ac110002",
		NodePoolName:    "",
		EnableAutoScale: &enableAutoScale,
		MaxNum:          2,
		MinNum:          1,
		BillMode:        "1",
		CycleCount:      0,
		CycleType:       "MONTH",
		AutoRenewStatus: 0,
		AzInfo: []*CcseCreateNodePoolAzInfoRequest{
			{
				AzName: "cn-xinan1-1A",
			},
		},
		ContainerRuntime: "containerd",
		VmSpecName:       "c7.xlarge.2",
		ImageType:        1,
		ImageName:        "Centos-79-CCND-CCSE-40-07-amd",
		ImageUuid:        "a8f857a8-ee19-4dc8-a193-819e8ed10dc9",
		LoginType:        "password",
		Password:         "",
		KeyName:          "KeyPair-a589",
		KeyPairId:        "ba425a97-9ad9-2d45-e21a-770d2ebeb477",
		SysDiskType:      "SATA",
		SysDiskSize:      0,
		SysDiskDecTypeId: "b0d48eaf-e164-4873-9b89-e3dc85c8bed0",
		DataDisks: []*CcseCreateNodePoolDataDisksRequest{
			{
				Size:         100,
				DiskSpecName: "SATA",
				DecTypeId:    "b0d48eaf-e164-4873-9b89-e3dc85c8bed0",
			},
		},
		SecurityGroupId:          "sg-8judj901ou",
		SubnetUuid:               "subnet-7xipneei60",
		DefinedHostnameEnable:    0,
		HostNamePrefix:           "",
		HostNamePostfix:          "",
		VisibilityHostScript:     "",
		VisibilityPostHostScript: "",
		Labels:                   map[string]string{},
		Annotations:              map[string]string{},
		Taints: []*CcseCreateNodePoolTaintsRequest{
			{
				Key:    "aaa",
				Value:  "bbb",
				Effect: "NoSchedule",
			},
		},
		SyncNodeLabels: &syncNodeLabels,
		SyncNodeAnnotations: &syncNodeAnnotations,
		SyncNodeTaints: &syncNodeTaints,
		KubeletArgs: &CcseCreateNodePoolKubeletArgsRequest{
			KubeAPIQPS:           50,
			KubeAPIBurst:         100,
			MaxPods:              110,
			RegistryPullQPS:      5,
			RegistryBurst:        10,
			PodPidsLimit:         -1,
			EventRecordQPS:       50,
			EventBurst:           100,
			TopologyManagerScope: "container",
			CpuCFSQuota:          &cpuCFSQuota,
		},
		K8sNodeNameType:             "cceNodeName",
		NodeUnschedulable:           &nodeUnschedulable,
		IsSyncClusterResourceLabels: &isSyncClusterResourceLabels,
		ResourceLabels:              map[string]string{},
		KubeletDirectory:            "",
		ContainerDataDirectory:      "",
		UseAffinityGroup:            &useAffinityGroup,
		AffinityGroupUuid:           "",
		AutoRepair:                  0,
		Description:                 "",
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
