package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseCreatedNodesV2Api_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseCreatedNodesV2Api

	// 构造请求
	var isSyncClusterResourceLabels bool = false
	var useAffinityGroup bool = false
	var cpuCFSQuota bool = false
	request := &CcseCreatedNodesV2Request{
		ClusterId: "47281b02f87757478f20b1827c97cadf",
		RegionId:  "bb9fdb42056f11eda1610242ac110002",
		NodeMetadata: &CcseCreatedNodesV2NodeMetadataRequest{
			BillMode:         "1",
			CycleCount:       1,
			CycleType:        "MONTH",
			AutoRenewStatus:  0,
			AzNames:          []string{},
			ContainerRuntime: "containerd",
			VmSpecName:       "c7.xlarge.2",
			ImageType:        1,
			ImageName:        "Centos-79-CCND-CCSE-40-07-amd",
			ImageUuid:        "a8f857a8-ee19-4dc8-a193-819e8ed10dc9",
			LoginType:        "password",
			Password:         "",
			KeyName:          "KeyPair-a589",
			KeyPairId:        "ba425a97-9ad9-2d45-e21a-770d2ebeb477",
		},
		Count: 1,
		StorageSpec: &CcseCreatedNodesV2StorageSpecRequest{
			SysDiskSize: 120,
			SysDiskType: "SAS",
			DataDisks: []*CcseCreatedNodesV2StorageSpecDataDisksRequest{
				{
					DiskSpecName: "SAS",
					Size:         0,
				},
			},
		},
		NicSpec: &CcseCreatedNodesV2NicSpecRequest{
			SecurityGroupId: "sg-8judj901ou",
			SubnetUuid:      "subnet-7xipneei60",
		},
		AdvancedSpec: &CcseCreatedNodesV2AdvancedSpecRequest{
			VisibilityPostHostScript: "",
			VisibilityHostScript:     "",
			Labels:                   map[string]string{},
			Annotations:              map[string]string{},
			Taints: []*CcseCreatedNodesV2AdvancedSpecTaintsRequest{
				{
					Key:    "aaa",
					Value:  "aaa",
					Effect: "NoSchedule",
				},
			},
			KubeletArgs: &CcseCreatedNodesV2AdvancedSpecKubeletArgsRequest{
				KubeAPIQPS:           50,
				KubeAPIBurst:         100,
				MaxPods:              110,
				RegistryPullQPS:      5,
				RegistryBurst:        10,
				PodPidsLimit:         -1,
				EventRecordQPS:       50,
				EventBurst:           100,
				TopologyManagerScope: "container",
				CpuCFSQuota:          &cpuCFSQuota,
			},
			IsSyncClusterResourceLabels: &isSyncClusterResourceLabels,
			ResourceLabels:              map[string]string{},
			KubeletDirectory:            "",
			ContainerDataDirectory:      "",
			UseAffinityGroup:            &useAffinityGroup,
			AffinityGroupUuid:           "",
		},
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
