package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseDeleteInspectionReportApi
/* 调用该接口删除集群巡检报告
 */type CcseDeleteInspectionReportApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseDeleteInspectionReportApi(client *core.CtyunClient) *CcseDeleteInspectionReportApi {
	return &CcseDeleteInspectionReportApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodDelete,
			UrlPath:      "/v2/cce/clusters/{clusterId}/inspection/reports/{reportId}",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseDeleteInspectionReportApi) Do(ctx context.Context, credential core.Credential, req *CcseDeleteInspectionReportRequest) (*CcseDeleteInspectionReportResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder = builder.ReplaceUrl("reportId", req.ReportId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseDeleteInspectionReportResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseDeleteInspectionReportRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。  */
	ReportId  string `json:"reportId,omitempty"`  /*  巡检报告ID  */
	RegionId  string `json:"regionId,omitempty"`  /*  <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
}

type CcseDeleteInspectionReportResponse struct {
	StatusCode int32                                        `json:"statusCode"` /*  状态码  */
	Message    string                                       `json:"message"`    /*  提示信息  */
	ReturnObj  *CcseDeleteInspectionReportReturnObjResponse `json:"returnObj"`  /*  返回对象  */
	Error      string                                       `json:"error"`      /*  错误码  */
}

type CcseDeleteInspectionReportReturnObjResponse struct{}
