package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseGetClusterSeriesTaskApi
/* 调用该接口查询托管版集群规格变更任务状态。
 */type CcseGetClusterSeriesTaskApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseGetClusterSeriesTaskApi(client *core.CtyunClient) *CcseGetClusterSeriesTaskApi {
	return &CcseGetClusterSeriesTaskApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodGet,
			UrlPath:      "/v2/cce/clusters/{clusterId}/seriestask",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseGetClusterSeriesTaskApi) Do(ctx context.Context, credential core.Credential, req *CcseGetClusterSeriesTaskRequest) (*CcseGetClusterSeriesTaskResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	if req.TaskId != "" {
		ctReq.AddParam("taskId", req.TaskId)
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseGetClusterSeriesTaskResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseGetClusterSeriesTaskRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>。  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	TaskId string `json:"taskId,omitempty"` /*  任务ID，可通过 变更集群规格 接口获取，不传时默认查询最新的集群规格变更任务状态  */
}

type CcseGetClusterSeriesTaskResponse struct {
	Code       int32                                      `json:"code"`       /*  请求结果编码  */
	RequestId  string                                     `json:"requestId"`  /*  请求id  */
	StatusCode int32                                      `json:"statusCode"` /*  状态码  */
	Message    string                                     `json:"message"`    /*  提示信息  */
	ReturnObj  *CcseGetClusterSeriesTaskReturnObjResponse `json:"returnObj"`  /*  集群规格变更任务详情  */
	Error      string                                     `json:"error"`      /*  错误码  */
}

type CcseGetClusterSeriesTaskReturnObjResponse struct {
	TaskId             string `json:"taskId"`             /*  任务ID  */
	ClusterId          string `json:"clusterId"`          /*  集群ID  */
	RegionId           string `json:"regionId"`           /*  资源池Id  */
	TaskType           string `json:"taskType"`           /*  任务类型，cluster_master_series_modify代表集群规格变更任务  */
	TaskStatus         string `json:"taskStatus"`         /*  任务状态  */
	ParallelNumber     int32  `json:"parallelNumber"`     /*  并行数  */
	ParentTaskId       int32  `json:"parentTaskId"`       /*  父任务ID  */
	TaskSequenceNumber int32  `json:"taskSequenceNumber"` /*  任务序列号  */
	SubtaskSize        int32  `json:"subtaskSize"`        /*  子任务数量  */
	CompleteSubTaskNum int32  `json:"completeSubTaskNum"` /*  已完成的子任务数量  */
	TaskContent        string `json:"taskContent"`        /*  任务内容  */
	TaskResult         string `json:"taskResult"`         /*  任务执行结果  */
	RetryTime          int32  `json:"retryTime"`          /*  重试次数  */
	CreatedBy          int64  `json:"createdBy"`          /*  创建人  */
	CreatedTime        string `json:"createdTime"`        /*  创建时间  */
	ModifyTime         string `json:"modifyTime"`         /*  修改时间  */
}
