package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseGetClusterServiceCidrApi
/* 查询集群服务网段（ServiceCidr资源）列表
 */type CcseGetClusterServiceCidrApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseGetClusterServiceCidrApi(client *core.CtyunClient) *CcseGetClusterServiceCidrApi {
	return &CcseGetClusterServiceCidrApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodGet,
			UrlPath:      "/v2/cce/clusters/{clusterId}/apis/networking.k8s.io/v1beta1/servicecidrs",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseGetClusterServiceCidrApi) Do(ctx context.Context, credential core.Credential, req *CcseGetClusterServiceCidrRequest) (*CcseGetClusterServiceCidrResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseGetClusterServiceCidrResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseGetClusterServiceCidrRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	 */
}

type CcseGetClusterServiceCidrResponse struct {
	StatusCode int32  `json:"statusCode"` /*  响应状态码  */
	Message    string `json:"message"`    /*  响应信息  */
	ReturnObj  string `json:"returnObj"`  /*  字符串类型的多个ServiceCidr资源yaml定义  */
	Error      string `json:"error"`      /*  错误码，参见错误码说明  */
}
