package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseGetPluginInstanceApi
/* 调用该接口可查询插件实例的详细信息。
 */type CcseGetPluginInstanceApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseGetPluginInstanceApi(client *core.CtyunClient) *CcseGetPluginInstanceApi {
	return &CcseGetPluginInstanceApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodGet,
			UrlPath:      "/v2/cce/clusters/{clusterId}/plugininstance/{instanceName}/detail",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseGetPluginInstanceApi) Do(ctx context.Context, credential core.Credential, req *CcseGetPluginInstanceRequest) (*CcseGetPluginInstanceResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder = builder.ReplaceUrl("instanceName", req.InstanceName)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseGetPluginInstanceResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseGetPluginInstanceRequest struct {
	ClusterId    string `json:"clusterId,omitempty"`    /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。  */
	InstanceName string `json:"instanceName,omitempty"` /*  插件名称  */
	RegionId     string `json:"regionId,omitempty"`     /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
}

type CcseGetPluginInstanceResponse struct {
	StatusCode int32                                   `json:"statusCode"` /*  状态码  */
	RequestId  string                                  `json:"requestId"`  /*  请求id  */
	Message    string                                  `json:"message"`    /*  提示信息  */
	ReturnObj  *CcseGetPluginInstanceReturnObjResponse `json:"returnObj"`  /*  返回对象  */
	Error      string                                  `json:"error"`      /*  错误码  */
}

type CcseGetPluginInstanceReturnObjResponse struct {
	ReleaseHistoryListDTOS []*CcseGetPluginInstanceReturnObjReleaseHistoryListDTOSResponse `json:"releaseHistoryListDTOS"` /*  插件实例发布历史版本列表  */
	FirstDeployTime        string                                                          `json:"firstDeployTime"`        /*  首次发布时间。  */
	LastDeployTime         string                                                          `json:"lastDeployTime"`         /*  最新发布时间。  */
	Name                   string                                                          `json:"name"`                   /*  插件实例名称。  */
	Namespace              string                                                          `json:"namespace"`              /*  命名空间。  */
	Values                 string                                                          `json:"values"`                 /*  values参数。  */
	ResourceDTOS           []*CcseGetPluginInstanceReturnObjResourceDTOSResponse           `json:"resourceDTOS"`           /*  资源列表。  */
	ClusterName            string                                                          `json:"clusterName"`            /*  集群ID  */
	CreatedTime            string                                                          `json:"createdTime"`            /*  创建时间  */
	ChartVersion           string                                                          `json:"chartVersion"`           /*  chart版本  */
	Status                 string                                                          `json:"status"`                 /*  状态  */
	Readme                 string                                                          `json:"readme"`                 /*  说明  */
	ChartUrl               string                                                          `json:"chartUrl"`               /*  chart url  */
	RepositoryId           string                                                          `json:"repositoryId"`           /*  仓库ID  */
	ChartName              string                                                          `json:"chartName"`              /*  chart名称  */
	Icon                   string                                                          `json:"icon"`                   /*  icon名称  */
}

type CcseGetPluginInstanceReturnObjReleaseHistoryListDTOSResponse struct {
	Revision     string `json:"revision"`     /*  版本  */
	Updated      string `json:"updated"`      /*  更新时间。  */
	Status       string `json:"status"`       /*  状态。  */
	Chart        string `json:"chart"`        /*  Chart名称和版本。  */
	AppVersion   string `json:"appVersion"`   /*  版本。  */
	Description  string `json:"description"`  /*  描述。  */
	ClusterId    string `json:"clusterId"`    /*  集群ID。  */
	Name         string `json:"name"`         /*  实例名称。  */
	Namespace    string `json:"namespace"`    /*  命名空间。  */
	ChartName    string `json:"chartName"`    /*  Chart名称。  */
	ChartVersion string `json:"chartVersion"` /*  Chart版本。  */
}

type CcseGetPluginInstanceReturnObjResourceDTOSResponse struct {
	Name      string `json:"name"`      /*  资源名称。  */
	Namespace string `json:"namespace"` /*  资源命名空间。  */
	Kind      string `json:"kind"`      /*  资源kind。  */
	Yaml      string `json:"yaml"`      /*  资源内容。  */
}
