package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseListClustersApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseListClustersApi

	// 构造请求
	request := &CcseListClustersRequest{
		RegionId:    "bb9fdb42056f11eda1610242ac110002",
		ClusterName: "ccse-demo",
		ResPoolId:   "bb9fdb42056f11eda1610242ac110002",
		PageNow:     1,
		PageSize:    10,
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
