package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseListEventsApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseListEventsApi

	// 构造请求
	request := &CcseListEventsRequest{
		ClusterId:     "47281b02f87757478f20b1827c97cadf",
		RegionId:      "bb9fdb42056f11eda1610242ac110002",
		LabelSelector: "name%3Daaa",
		FieldSelector: "regarding.kind%3DPod,type%3DNormal",
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
