package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseQueryClusterIdByOrderIdApi
/* 根据创建集群接口返回的orderId调用该接口查询集群id
 */type CcseQueryClusterIdByOrderIdApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseQueryClusterIdByOrderIdApi(client *core.CtyunClient) *CcseQueryClusterIdByOrderIdApi {
	return &CcseQueryClusterIdByOrderIdApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodGet,
			UrlPath:      "/v2/cce/clusters/queryClusterIdByOrderId",
			ContentType:  "",
		},
	}
}

func (a *CcseQueryClusterIdByOrderIdApi) Do(ctx context.Context, credential core.Credential, req *CcseQueryClusterIdByOrderIdRequest) (*CcseQueryClusterIdByOrderIdResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	ctReq.AddParam("orderId", req.OrderId)
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseQueryClusterIdByOrderIdResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseQueryClusterIdByOrderIdRequest struct {
	RegionId string `json:"regionId,omitempty"` /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	OrderId string `json:"orderId,omitempty"` /*  创建集群接口返回的orderId  */
}

type CcseQueryClusterIdByOrderIdResponse struct {
	StatusCode int32  `json:"statusCode"` /*  状态码  */
	Message    string `json:"message"`    /*  提示信息  */
	Error      string `json:"error"`      /*  错误码  */
	ReturnObj  string `json:"returnObj"`  /*  返回对象，集群id  */
}
