package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseQueryInspectionReportDetailApi
/* 调用该接口查询巡检报告详情
 */type CcseQueryInspectionReportDetailApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseQueryInspectionReportDetailApi(client *core.CtyunClient) *CcseQueryInspectionReportDetailApi {
	return &CcseQueryInspectionReportDetailApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodGet,
			UrlPath:      "/v2/cce/clusters/{clusterId}/inspection/reports/{reportId}",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseQueryInspectionReportDetailApi) Do(ctx context.Context, credential core.Credential, req *CcseQueryInspectionReportDetailRequest) (*CcseQueryInspectionReportDetailResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder = builder.ReplaceUrl("reportId", req.ReportId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	ctReq.AddParam("pageNow", req.PageNow)
	ctReq.AddParam("pageSize", req.PageSize)
	if req.Namespace != "" {
		ctReq.AddParam("namespace", req.Namespace)
	}
	if req.ResourceType != "" {
		ctReq.AddParam("resourceType", req.ResourceType)
	}
	if req.Level != "" {
		ctReq.AddParam("level", req.Level)
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseQueryInspectionReportDetailResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseQueryInspectionReportDetailRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。  */
	ReportId  string `json:"reportId,omitempty"`  /*  巡检报告ID  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	PageNow      string `json:"pageNow,omitempty"`      /*  当前页码  */
	PageSize     string `json:"pageSize,omitempty"`     /*  每页条数  */
	Namespace    string `json:"namespace,omitempty"`    /*  过滤风险项的命名空间  */
	ResourceType string `json:"resourceType,omitempty"` /*  过滤风险项的资源类型，多种资源类型用“,”分隔，支持的资源类型：
	集群节点：Node
	集群工作负载：Deployment,ReplicaSet,DaemonSet,StatefulSet,Job
	集群Pod：Pod
	集群权限：Role,ClusterRole
	集群证书：Cert
	集群异常事件：Event  */
	Level string `json:"level,omitempty"` /*  过滤风险项的级别，多种级别用“,”分隔，支持的级别
	danger：高危
	warning：警告
	ignore：提示  */
}

type CcseQueryInspectionReportDetailResponse struct {
	StatusCode int32                                             `json:"statusCode"` /*  状态码  */
	Message    string                                            `json:"message"`    /*  提示信息  */
	ReturnObj  *CcseQueryInspectionReportDetailReturnObjResponse `json:"returnObj"`  /*  返回对象  */
	Error      string                                            `json:"error"`      /*  错误码  */
}

type CcseQueryInspectionReportDetailReturnObjResponse struct {
	ReportId  string                                                 `json:"reportId"`  /*  巡检报告ID  */
	StartTime string                                                 `json:"startTime"` /*  巡检开始时间  */
	EndTime   string                                                 `json:"endTime"`   /*  巡检结束时间  */
	Items     *CcseQueryInspectionReportDetailReturnObjItemsResponse `json:"items"`     /*  巡检风险项  */
}

type CcseQueryInspectionReportDetailReturnObjItemsResponse struct {
	Records []*CcseQueryInspectionReportDetailReturnObjItemsRecordsResponse `json:"records"` /*  记录列表	  */
	Total   int32                                                           `json:"total"`   /*  总条数  */
	Size    int32                                                           `json:"size"`    /*  每页条数  */
	Current int32                                                           `json:"current"` /*  当前页码  */
	Pages   int32                                                           `json:"pages"`   /*  总页数  */
}

type CcseQueryInspectionReportDetailReturnObjItemsRecordsResponse struct {
	Namespace    string `json:"namespace"`    /*  命名空间  */
	ResourceType string `json:"resourceType"` /*  资源类型  */
	ResourceName string `json:"resourceName"` /*  资源名  */
	Level        string `json:"level"`        /*  风险项级别  */
	Message      string `json:"message"`      /*  风险检查项  */
	Describe     string `json:"describe"`     /*  异常影响  */
	Suggest      string `json:"suggest"`      /*  解决方案  */
}
