package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseQueryInspectionReportDetailApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseQueryInspectionReportDetailApi

	// 构造请求
	request := &CcseQueryInspectionReportDetailRequest{
		ClusterId:    "47281b02f87757478f20b1827c97cadf",
		ReportId:     "52174b1f-b91c-44fd-b629-9c8fe79a8e9d",
		RegionId:     "bb9fdb42056f11eda1610242ac110002",
		PageNow:      "1",
		PageSize:     "10",
		Namespace:    "",
		ResourceType: "Node,Deployment",
		Level:        "danger,warning,ignore",
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
