package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseQueryInspectionReportsApi
/* 调用该接口查询巡检报告列表
 */type CcseQueryInspectionReportsApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseQueryInspectionReportsApi(client *core.CtyunClient) *CcseQueryInspectionReportsApi {
	return &CcseQueryInspectionReportsApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodGet,
			UrlPath:      "/v2/cce/clusters/{clusterId}/inspection/reports",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseQueryInspectionReportsApi) Do(ctx context.Context, credential core.Credential, req *CcseQueryInspectionReportsRequest) (*CcseQueryInspectionReportsResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	ctReq.AddParam("pageNow", req.PageNow)
	ctReq.AddParam("pageSize", req.PageSize)
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseQueryInspectionReportsResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseQueryInspectionReportsRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。  */
	RegionId  string `json:"regionId,omitempty"`  /*  <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	PageNow   string `json:"pageNow,omitempty"`   /*  当前页码  */
	PageSize  string `json:"pageSize,omitempty"`  /*  每页条数  */
}

type CcseQueryInspectionReportsResponse struct {
	StatusCode int32  `json:"statusCode"` /*  状态码  */
	Message    string `json:"message"`    /*  提示信息  */
	ReturnObj  string `json:"returnObj"`  /*  返回对象  */
	Error      string `json:"error"`      /*  错误码  */
}
