package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseRenewClusterApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseRenewClusterApi

	// 构造请求
	request := &CcseRenewClusterRequest{
		RegionId:  "b342b77ef26b11ecb0ac0242ac110002",
		ResPoolId: "",
		ClusterId: "397ea07237b745bc886f08bd571d30f5",
		CycleType: "3",
		CycleCnt:  1,
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
