package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseResumeClusterTaskApi
/* 恢复任务
 */type CcseResumeClusterTaskApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseResumeClusterTaskApi(client *core.CtyunClient) *CcseResumeClusterTaskApi {
	return &CcseResumeClusterTaskApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPost,
			UrlPath:      "/v2/cce/tasks/{taskId}/resume",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseResumeClusterTaskApi) Do(ctx context.Context, credential core.Credential, req *CcseResumeClusterTaskRequest) (*CcseResumeClusterTaskResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("taskId", req.TaskId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseResumeClusterTaskResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseResumeClusterTaskRequest struct {
	TaskId   string `json:"taskId,omitempty"`   /*  任务ID，具体可参考<a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=17939&data=128&isNormal=1&vid=121" target="_blank">升级节点池</a>等接口返回值taskId。  */
	RegionId string `json:"regionId,omitempty"` /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
}

type CcseResumeClusterTaskResponse struct {
	StatusCode int32                                   `json:"statusCode"` /*  响应状态码  */
	RequestId  string                                  `json:"requestId"`  /*  请求ID  */
	Message    string                                  `json:"message"`    /*  响应信息  */
	ReturnObj  *CcseResumeClusterTaskReturnObjResponse `json:"returnObj"`  /*  请求结果  */
	Error      string                                  `json:"error"`      /*  错误码，参见错误码说明  */
}

type CcseResumeClusterTaskReturnObjResponse struct{}
