package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseScaleDownNodePoolApi
/* 调用该接口删除节点池中的指定节点。
 */type CcseScaleDownNodePoolApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseScaleDownNodePoolApi(client *core.CtyunClient) *CcseScaleDownNodePoolApi {
	return &CcseScaleDownNodePoolApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPut,
			UrlPath:      "/v2/cce/clusters/{clusterId}/nodepool/{nodePoolId}/scaledown",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseScaleDownNodePoolApi) Do(ctx context.Context, credential core.Credential, req *CcseScaleDownNodePoolRequest) (*CcseScaleDownNodePoolResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder = builder.ReplaceUrl("nodePoolId", req.NodePoolId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	_, err := ctReq.WriteJson(struct {
		*CcseScaleDownNodePoolRequest
		RegionId   interface{} `json:"regionId,omitempty"`
		ClusterId  interface{} `json:"clusterId,omitempty"`
		NodePoolId interface{} `json:"nodePoolId,omitempty"`
	}{
		req, nil, nil, nil,
	}, a.template.ContentType)
	if err != nil {
		return nil, err
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseScaleDownNodePoolResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseScaleDownNodePoolRequest struct {
	ClusterId  string `json:"clusterId,omitempty"`  /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>。  */
	NodePoolId string `json:"nodePoolId,omitempty"` /*  节点池Id，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>。  */
	RegionId   string `json:"regionId,omitempty"`   /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	NodeNames      []string `json:"nodeNames"`      /*  缩容节点的名称  */
	ForcedDeletion *bool    `json:"forcedDeletion"` /*  是否从集群中强制缩容，默认值true。当值为true时，即使节点处于缩容保护，也会强制缩容  */
}

type CcseScaleDownNodePoolResponse struct {
	StatusCode int32  `json:"statusCode"` /*  状态码  */
	RequestId  string `json:"requestId"`  /*  请求ID  */
	Message    string `json:"message"`    /*  提示信息  */
	ReturnObj  string `json:"returnObj"`  /*  返回对象，为伸缩记录的id，可通过伸缩记录详情接口查看伸缩状态  */
	Error      string `json:"error"`      /*  错误码  */
}
