package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseUpdateClusterServiceCidrApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseUpdateClusterServiceCidrApi

	// 构造请求
	request := &CcseUpdateClusterServiceCidrRequest{
		ClusterId:           "",
		ResourceName:        "newcidr1",
		RegionId:            "b342b77ef26b11ecb0ac0242ac110002",
		TextPlainDataString: "",
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
