package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseUpdateControlPlaneArgsApi
/* 调用该接口修改控制面组件参数
 */type CcseUpdateControlPlaneArgsApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseUpdateControlPlaneArgsApi(client *core.CtyunClient) *CcseUpdateControlPlaneArgsApi {
	return &CcseUpdateControlPlaneArgsApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPut,
			UrlPath:      "/v2/cce/clusters/{clusterId}/controlplane/arguments",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseUpdateControlPlaneArgsApi) Do(ctx context.Context, credential core.Credential, req *CcseUpdateControlPlaneArgsRequest) (*CcseUpdateControlPlaneArgsResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	_, err := ctReq.WriteJson(struct {
		*CcseUpdateControlPlaneArgsRequest
		RegionId  interface{} `json:"regionId,omitempty"`
		ClusterId interface{} `json:"clusterId,omitempty"`
	}{
		req, nil, nil,
	}, a.template.ContentType)
	if err != nil {
		return nil, err
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseUpdateControlPlaneArgsResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseUpdateControlPlaneArgsRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	KubeApiServer         *CcseUpdateControlPlaneArgsKubeApiServerRequest         `json:"kubeApiServer"`         /*  apis启动参数  */
	KubeControllerManager *CcseUpdateControlPlaneArgsKubeControllerManagerRequest `json:"kubeControllerManager"` /*  kcm启动参数  */
	KubeScheduler         *CcseUpdateControlPlaneArgsKubeSchedulerRequest         `json:"kubeScheduler"`         /*  scheduler启动参数  */
}

type CcseUpdateControlPlaneArgsKubeApiServerRequest struct {
	RequestTimeout                                 string `json:"requestTimeout,omitempty"`                       /*  指示处理程序在超时之前必须保持打开请求的持续时间，仅支持单位秒(s)  */
	MaxMutatingRequestsInflight                    string `json:"maxMutatingRequestsInflight,omitempty"`          /*  修改类API请求最大并发数  */
	MaxRequestsInflight                            string `json:"maxRequestsInflight,omitempty"`                  /*  非修改类API请求最大并发数  */
	DefaultNotReadyTolerationSeconds               string `json:"defaultNotReadyTolerationSeconds,omitempty"`     /*  对污点 NotReady:NoExecute 的容忍时长  */
	DefaultUnreachableTolerationSeconds            string `json:"defaultUnreachableTolerationSeconds,omitempty"`  /*  对污点 Unreachable:NoExecute 的容忍时长  */
	EnableAdmissionPluginsNodeRestriction          *bool  `json:"enableAdmissionPluginsNodeRestriction"`          /*  节点限制插件  */
	EnableAdmissionPluginsPodNodeSelector          *bool  `json:"enableAdmissionPluginsPodNodeSelector"`          /*  节点选择器插件  */
	EnableAdmissionPluginsPodTolerationRestriction *bool  `json:"enableAdmissionPluginsPodTolerationRestriction"` /*  容忍度限制插件  */
	ApiAudiences                                   string `json:"apiAudiences,omitempty"`                         /*  API 的标识符  */
	ServiceAccountIssuer                           string `json:"serviceAccountIssuer,omitempty"`                 /*  服务帐号令牌颁发者的标识符  */
}

type CcseUpdateControlPlaneArgsKubeControllerManagerRequest struct {
	KubeApiQps                                     string `json:"kubeApiQps,omitempty"`                                     /*  与 API 服务器通信时每秒请求数（QPS）限制  */
	KubeApiBurst                                   string `json:"kubeApiBurst,omitempty"`                                   /*  与 Kubernetes API 服务器通信时突发峰值请求个数上限  */
	ConcurrentDeploymentSyncs                      string `json:"concurrentDeploymentSyncs,omitempty"`                      /*  并发同步的 Deployment 对象个数  */
	ConcurrentEndpointSyncs                        string `json:"concurrentEndpointSyncs,omitempty"`                        /*  并发执行的 Endpoints 同步操作个数  */
	ConcurrentGcSyncs                              string `json:"concurrentGcSyncs,omitempty"`                              /*  并发同步的垃圾收集工作线程个数  */
	ConcurrentJobSyncs                             string `json:"concurrentJobSyncs,omitempty"`                             /*  并发同步的 Job 对象个数；Kubernetes 1.28版本引入，若集群版本低于1.28，设值会被忽略  */
	ConcurrentCronJobSyncs                         string `json:"concurrentCronJobSyncs,omitempty"`                         /*  并发同步的 CronJob 对象个数；Kubernetes 1.28版本引入，若集群版本低于1.28，设值会被忽略  */
	ConcurrentNamespaceSyncs                       string `json:"concurrentNamespaceSyncs,omitempty"`                       /*  并发同步的 Namespace 对象个数  */
	ConcurrentReplicasetSyncs                      string `json:"concurrentReplicasetSyncs,omitempty"`                      /*  并发同步的 ReplicaSet 个数  */
	ConcurrentResourceQuotaSyncs                   string `json:"concurrentResourceQuotaSyncs,omitempty"`                   /*  并发同步的 ResourceQuota 对象个数  */
	ConcurrentServiceSyncs                         string `json:"concurrentServiceSyncs,omitempty"`                         /*  并发同步的 Service 对象个数  */
	ConcurrentServiceaccountTokenSyncs             string `json:"concurrentServiceaccountTokenSyncs,omitempty"`             /*  并发同步的服务账号令牌对象个数  */
	ConcurrentTtlAfterFinishedSyncs                string `json:"concurrentTtlAfterFinishedSyncs,omitempty"`                /*  并发同步的 ttl-after-finished-controller 线程个数  */
	ConcurrentHorizontalPodAutoscalerSyncs         string `json:"concurrentHorizontalPodAutoscalerSyncs,omitempty"`         /*  并发执行的、对水平 Pod 自动扩缩器对象进行同步的数量；Kubernetes 1.26版本引入，若集群版本低于1.26，设值会被忽略  */
	UnhealthyZoneThreshold                         string `json:"unhealthyZoneThreshold,omitempty"`                         /*  仅当给定区域中处于非就绪状态的节点（最少 3 个）的占比高于此值时， 才将该区域视为不健康  */
	SecondaryNodeEvictionRate                      string `json:"secondaryNodeEvictionRate,omitempty"`                      /*  区域不健康造成节点失效时，每秒钟从此标志所给的节点上删除 Pod 的节点个数  */
	LargeClusterSizeThreshold                      string `json:"largeClusterSizeThreshold,omitempty"`                      /*  判断所在集群是否为大规模集群  */
	NodeEvictionRate                               string `json:"nodeEvictionRate,omitempty"`                               /*  节点故障的情况下每秒删除 Pods 的节点数  */
	HorizontalPodAutoscalerSyncPeriod              string `json:"horizontalPodAutoscalerSyncPeriod,omitempty"`              /*  水平 Pod 扩缩器对 Pod 数目执行同步操作的周期，仅支持单位秒(s)  */
	HorizontalPodAutoscalerTolerance               string `json:"horizontalPodAutoscalerTolerance,omitempty"`               /*  对伸缩策略相关指标反映的灵敏程度  */
	HorizontalPodAutoscalerCpuInitializationPeriod string `json:"horizontalPodAutoscalerCpuInitializationPeriod,omitempty"` /*  Pod 启动之后可以忽略 CPU 采样值的时长，仅支持单位秒(s)  */
	HorizontalPodAutoscalerInitialReadinessDelay   string `json:"horizontalPodAutoscalerInitialReadinessDelay,omitempty"`   /*  自动扩缩程序的回溯时长，仅支持单位秒(s)  */
	TerminatedPodGcThreshold                       string `json:"terminatedPodGcThreshold,omitempty"`                       /*  在已终止 Pod 垃圾收集器删除已终止 Pod 之前，可以保留的已终止 Pod 的个数上限  */
	ControllersResourceQuota                       *bool  `json:"controllersResourceQuota"`                                 /*  启用的控制器  */
}

type CcseUpdateControlPlaneArgsKubeSchedulerRequest struct {
	KubeApiQps   string `json:"kubeApiQps,omitempty"`   /*  与 API 服务器通信时每秒请求数（QPS）限制  */
	KubeApiBurst string `json:"kubeApiBurst,omitempty"` /*  与 Kubernetes API 服务器通信时突发峰值请求个数上限  */
}

type CcseUpdateControlPlaneArgsResponse struct {
	StatusCode int32  `json:"statusCode"` /*  响应状态码  */
	Message    string `json:"message"`    /*  响应信息  */
	ReturnObj  *bool  `json:"returnObj"`  /*  响应对象  */
	Error      string `json:"error"`      /*  错误码，参见错误码说明  */
}
