package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"testing"
)

func TestCcseUpdateControlPlaneArgsApi_Do(t *testing.T) {
	// 初始化
	client := core.DefaultClient()
	credential := core.NewCredential("<YOUR_AK>", "<YOUR_SK>")
	// credential := core.CredentialFromEnv()
	apis := NewApis("<YOUR_ENDPOINT>", client)
	api := apis.CcseUpdateControlPlaneArgsApi

	// 构造请求
	var enableAdmissionPluginsNodeRestriction bool = false
	var enableAdmissionPluginsPodNodeSelector bool = false
	var enableAdmissionPluginsPodTolerationRestriction bool = false
	var controllersResourceQuota bool = false
	request := &CcseUpdateControlPlaneArgsRequest{
		ClusterId: "",
		RegionId:  "b342b77ef26b11ecb0ac0242ac110002",
		KubeApiServer: &CcseUpdateControlPlaneArgsKubeApiServerRequest{
			RequestTimeout:                                 "60s",
			MaxMutatingRequestsInflight:                    "200",
			MaxRequestsInflight:                            "400",
			DefaultNotReadyTolerationSeconds:               "300",
			DefaultUnreachableTolerationSeconds:            "300",
			EnableAdmissionPluginsNodeRestriction:          &enableAdmissionPluginsNodeRestriction,
			EnableAdmissionPluginsPodNodeSelector:          &enableAdmissionPluginsPodNodeSelector,
			EnableAdmissionPluginsPodTolerationRestriction: &enableAdmissionPluginsPodTolerationRestriction,
			ApiAudiences:                                   "https://kubernetes.default.svc",
			ServiceAccountIssuer:                           "https://kubernetes.default.svc",
		},
		KubeControllerManager: &CcseUpdateControlPlaneArgsKubeControllerManagerRequest{
			KubeApiQps:                                     "20",
			KubeApiBurst:                                   "30",
			ConcurrentDeploymentSyncs:                      "5",
			ConcurrentEndpointSyncs:                        "5",
			ConcurrentGcSyncs:                              "20",
			ConcurrentJobSyncs:                             "5",
			ConcurrentCronJobSyncs:                         "5",
			ConcurrentNamespaceSyncs:                       "10",
			ConcurrentReplicasetSyncs:                      "5",
			ConcurrentResourceQuotaSyncs:                   "5",
			ConcurrentServiceSyncs:                         "1",
			ConcurrentServiceaccountTokenSyncs:             "5",
			ConcurrentTtlAfterFinishedSyncs:                "5",
			ConcurrentHorizontalPodAutoscalerSyncs:         "5",
			UnhealthyZoneThreshold:                         "0.55",
			SecondaryNodeEvictionRate:                      "0.01",
			LargeClusterSizeThreshold:                      "50",
			NodeEvictionRate:                               "0.1",
			HorizontalPodAutoscalerSyncPeriod:              "15s",
			HorizontalPodAutoscalerTolerance:               "0.1",
			HorizontalPodAutoscalerCpuInitializationPeriod: "300s",
			HorizontalPodAutoscalerInitialReadinessDelay:   "30s",
			TerminatedPodGcThreshold:                       "12500",
			ControllersResourceQuota:                       &controllersResourceQuota,
		},
		KubeScheduler: &CcseUpdateControlPlaneArgsKubeSchedulerRequest{
			KubeApiQps:   "50",
			KubeApiBurst: "100",
		},
	}

	// 发起调用
	response, err := api.Do(context.Background(), *credential, request)
	if err != nil {
		t.Log("request error:", err)
		t.Fail()
		return
	}
	t.Logf("%+v\n", *response)
}
