package apis

import (
	"context"
	"ctyun-go-sdk/core"
	"net/http"
)

// CcseUpdateSeriesAutoScaleApi
/* 调用该接口开启或关闭托管集群控制面规格自动变更。
 */type CcseUpdateSeriesAutoScaleApi struct {
	template core.CtyunRequestTemplate
	client   *core.CtyunClient
}

func NewCcseUpdateSeriesAutoScaleApi(client *core.CtyunClient) *CcseUpdateSeriesAutoScaleApi {
	return &CcseUpdateSeriesAutoScaleApi{
		client: client,
		template: core.CtyunRequestTemplate{
			EndpointName: EndpointName,
			Method:       http.MethodPut,
			UrlPath:      "/v2/cce/clusters/{clusterId}/seriesautoscale",
			ContentType:  "application/json",
		},
	}
}

func (a *CcseUpdateSeriesAutoScaleApi) Do(ctx context.Context, credential core.Credential, req *CcseUpdateSeriesAutoScaleRequest) (*CcseUpdateSeriesAutoScaleResponse, error) {
	builder := core.NewCtyunRequestBuilder(a.template)
	builder = builder.ReplaceUrl("clusterId", req.ClusterId)
	builder.WithCredential(credential)
	ctReq := builder.Build()
	ctReq.AddHeader("regionId", req.RegionId)
	_, err := ctReq.WriteJson(struct {
		*CcseUpdateSeriesAutoScaleRequest
		RegionId  interface{} `json:"regionId,omitempty"`
		ClusterId interface{} `json:"clusterId,omitempty"`
	}{
		req, nil, nil,
	}, a.template.ContentType)
	if err != nil {
		return nil, err
	}
	response, err := a.client.RequestToEndpoint(ctx, ctReq)
	if err != nil {
		return nil, err
	}
	var resp CcseUpdateSeriesAutoScaleResponse
	err = response.Parse(&resp)
	if err != nil {
		return nil, err
	}
	return &resp, nil
}

type CcseUpdateSeriesAutoScaleRequest struct {
	ClusterId string `json:"clusterId,omitempty"` /*  集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105" target="_blank">如何获取接口URI中参数</a>。  */
	RegionId  string `json:"regionId,omitempty"`  /*  资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
	另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
	获取：
	<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>  */
	Enabled bool `json:"enabled"` /*  是否开启托管集群控制面规格自动变更，true代表开启，false代表关闭  */
}

type CcseUpdateSeriesAutoScaleResponse struct {
	Code       int32  `json:"code"`       /*  请求结果编码  */
	RequestId  string `json:"requestId"`  /*  请求id  */
	StatusCode int32  `json:"statusCode"` /*  状态码  */
	Message    string `json:"message"`    /*  提示信息  */
	ReturnObj  *bool  `json:"returnObj"`  /*  请求是否成功  */
	Error      string `json:"error"`      /*  错误码  */
}
