<?php

class YunSign
{
    public $_ak;
    public $_sk;
    public $_method;
    public $_contentType;
    public $_url;
    public $_queryStr;
    public $_afterQuery;
    public $_queryParam;
    public $_headerMap;
    public $_body;
    public $_bodyByteArr;
    public $_dataMap;
    public $_fileMap;
    public $_uuId;

    public function YunSign($ak, $sk, $endingPoint, $uri, $method, $contentType, $headerParam, $queryParam, $body, $bodyParam, $bodyByteArr)
    {
        $this->_ak = $ak;
        $this->_sk = $sk;
        $this->_url = "https://" . $endingPoint . $uri;
        $this->_method = $method;
        $this->_contentType = $contentType;
        $this->_queryParam = $queryParam;
        if (!is_null($headerParam)) {
            $this->_headerMap = $headerParam;
        }
        $queryStr = "";
        if (!is_null($queryParam)) {
            foreach (array_keys($queryParam) as $key) {
                $queryStr = $queryStr . $key . "=" . $queryParam[$key] . "&";
            }
            if (strlen($queryStr) > 0) {
                $queryStr = substr($queryStr, 0, strlen($queryStr) - 1);
            }
        }
        $this->_queryStr = $queryStr;
        switch ($contentType) {
            case "application/json" :
                if (!is_null($body) && $body != "") {
//                    $this->_body = $body . self::tostr();
                    $this->_body = $body;
                } else {
                    $this->_body = "";
                }
                break;
            case "application/x-www-form-urlencoded":
                $bodyStr = "";
                if (!is_null($bodyParam) && $bodyParam != "") {
                    foreach (array_keys($bodyParam) as $key) {
                        $bodyStr = $bodyStr . $key . "=" . $bodyParam[$key] . "&";
                    }
                    if (strlen($bodyStr) > 0) {
                        $bodyStr = substr($bodyStr, 0, strlen($bodyStr) - 1);
                    }
                }
                $this->_body = $bodyStr;
                break;
            case "multipart/form-data":
                if (!is_null($bodyParam)) {
                    $ctFilesParam = array();
                    $bodyParam1 = array();
                    foreach (array_keys($bodyParam) as $key) {
                        if (!is_null($bodyParam[$key])) {
                            $path = json_decode($bodyParam[$key])->path;
                            if (!is_null($path) && file_exists($path)) {
                                $ctFilesParam[$key] = $path;
                            } else
                                $bodyParam1[$key] = $bodyParam[$key];
                        } else {
                            $bodyParam1[$key] = $bodyParam[$key];
                        }
                    }
                    $this->_dataMap = $bodyParam1;
                    $this->_fileMap = $ctFilesParam;
                }
                break;
            default:
                $this->_bodyByteArr = $bodyByteArr;
        }
    }

    public function com_create_guid()
    {

        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',

            mt_rand(0, 0xffff), mt_rand(0, 0xffff),

            mt_rand(0, 0xffff),

            mt_rand(0, 0x0fff) | 0x4000,

            mt_rand(0, 0x3fff) | 0x8000,

            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)

        );

    }

    public function toDo()
    {
        return $this->closeableHttpClient($this->_sk, $this->_ak, $this->_url, $this->_queryStr, $this->_headerMap, $this->_body, $this->_method, $this->_contentType, $this->_fileMap);
    }

    public function closeableHttpClient($SecurityKey = '', $accessKey = '', $url = '', $query = '', $header = array(), $body = array(), $flag = 'Post', $contextType = 'application/json', $fileMap = array())
    {
        date_default_timezone_set('Asia/Shanghai');
        $uuid = $this->com_create_guid();

        $time = date('Ymd', time()) . 'T' . date('His') . 'Z';

        $timeDate = substr($time, 0, 8);

        //传递的参数
        $postFields = '';
        //填充header参数中的contentType
        $headers = array();
        if (str_contains($contextType, 'application/json')) {
            $headers[0] = 'Content-Type:application/json';
            if ($body != null) {
                $postFields = json_encode($body);
            }
            print_r($postFields);
        } else if (str_contains($contextType, 'application/x-www-form-urlencoded')) {
            $headers[0] = 'Content-Type:application/x-www-form-urlencoded';
            if ($body != null) {
                $postFields = http_build_query($body);
            }
            echo($postFields);
        } else if (str_contains($contextType, 'multipart/form-data')) {
            $headers[0] = 'Content-Type:multipart/form-data; boundary=' . $uuid;
//            foreach ($fileMap as $key => $value) {
//                $files[$key] = (new CURLFILE($value));
//            }
            $postFields = self::get_byteList($fileMap, $uuid, $body);
        }

        $query = $this->encodeQueryStr($query);
        if ($query != null && $query != "") {
            $url = $url . "?" . $query;
        }

        $body = bin2hex(hash("sha256", "", true));

        $strsignature = "ctyun-eop-request-id:" . $uuid . "\n" . "eop-date:" . $time . "\n\n" .$query. "\n" . $body;

        $Ktime = $this->en($time, $SecurityKey);

        $kAk = $this->en($accessKey, $Ktime);

        $kdate = $this->en($timeDate, $kAk);

        $signature = base64_encode(($this->en($strsignature, $kdate)));

        $header1 = array(
            'ctyun-eop-request-id:' . $uuid,
            'Eop-Authorization:' . $accessKey . ' Headers=ctyun-eop-request-id;' . 'eop-date Signature=' . $signature,
            'eop-date:' . $time,
        );
        if (!is_null($header)) {
            $header = array_merge_recursive($header1, $header, $headers);
        } else
            $header = array_merge_recursive($header1, $headers);

        print_r("url            :".$url);
        print_r($header);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // 从证书中检查SSL加密算法是否存在
        //print_r($ch);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        switch ($flag) {
            case "GET" :
                curl_setopt($ch, CURLOPT_HTTPGET, true);
                break;
            case "POST":
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
                break;
            case "PUT" :
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
                break;
            case "DELETE":
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
                break;
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);//header请求。如不需要可以去掉
        print_r($ch);
        $response = curl_exec($ch);
        //$response = json_decode($response, true);
        print_r($response);
        return $response;

    }

    public function en($str, $pass)
    {
        $ret = (hash_hmac("sha256", ($str), ($pass), true));
        return $ret;
    }

    public function encodeQueryStr($str)
    {
        $afterQuery = "";
        if (!empty($str)) {
            $param = explode("&", $str);
            Var_dump($param);
            sort($param);
            Var_dump($param);
            foreach ($param as $arr) {
                if (strlen($afterQuery) < 1) {
                    $s = explode("=", $arr);
                    Var_dump($s);
                    if (count($s) >= 2) {
                        echo count($s);
                        $encodeStr = "";
                        $encodeStr = urlencode($s[1]);
                        Var_dump($s);
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . $arr;
                    } else {
                        $encodeStr = "";
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . $arr;
                    }
                } else {
                    $s = explode("=", $arr);
                    if (count($s) >= 2) {
                        $encodeStr = urlencode($s[1]);
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . "&" . $arr;
                    } else {
                        $encodeStr = "";
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . "&" . $arr;
                    }
                }
            }
        }
        return $afterQuery;
    }

    public static function get_byteList($fileMap, $uuid, $body)
    {
        $byteList = '';
        $contentType = 'multipart/form-data; boundary=' . $uuid;
        $boundary = $uuid;
        $boundary = '--' . $boundary;
        $order3 = "\r\n";
        foreach ($fileMap as $key => $value) {
            if (filesize($value) > 1048576) {
                echo "文件过大";
            }
            $body1 = $boundary . "\r\n" .
                "Content-Disposition: form-data; name=\"" . $key . "\"; filename=\"" . basename($value) . "\r\n" .
                "Content-Type: application/octet-stream" . "\r\n" . "\r\n";
            $order1 = ($body1);
            $order2 = (self::readbytes($value));
            $byteList = $byteList . $order1 . $order2 . $order3;
        }

        foreach ($body as $key => $value) {
            $body1 = '--' . $boundary . "\r\n" . "Content-Disposition: form-data; name=" . $key . "\r\n" . "\r\n" . $value . "\r\n";
            $byteList = $byteList . $body1 . $order3;
        }
        $byteList = $byteList . $boundary . '--' . $order3;

        return $byteList;
    }

    public static function tostr($bytes)
    {
        $str = '';
        foreach ($bytes as $ch) {
            $str .= chr($ch);
        }
        return $str;
    }

    public static function readbytes($filename)
    {

        $handle = fopen($filename, "rb");
        $contents = fread($handle, filesize($filename));
        fclose($handle);
        return $contents;
    }


}
