<?php

class Cty
{
    public function com_create_guid()
    {

        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',

            mt_rand(0, 0xffff), mt_rand(0, 0xffff),

            mt_rand(0, 0xffff),

            mt_rand(0, 0x0fff) | 0x4000,

            mt_rand(0, 0x3fff) | 0x8000,

            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)

        );

    }

    public function ctyun($SecurityKey, $accessKey, $url, $query, $header, $body, $flag, $contextType, $fileMap)
    {

        date_default_timezone_set('Asia/Shanghai');
        $uuid = $this->com_create_guid();

        $time = date('Ymd', time()) . 'T' . date('His') . 'Z';

        $timeDate = substr($time, 0, 8);

        //传递的参数
        $postFields = '';
        //填充header参数中的contentType
        $headers = array();
        if (str_contains($contextType, 'application/json')) {
            $headers[0] = 'Content-Type:application/json';
            print_r($body);
            $postFields = json_encode($body);
            echo($postFields);
        } else if (str_contains($contextType, 'application/x-www-form-urlencoded')) {
            $headers[0] = 'Content-Type:application/x-www-form-urlencoded';
            print_r($body);
            $postFields = http_build_query($body);
            echo($postFields);
        } else if (str_contains($contextType ,'multipart/form-data')){
            $headers[0] = 'Content-Type:multipart/form-data; boundary='.$uuid;
//            foreach ($fileMap as $key => $value) {
//                $files[$key] = (new CURLFILE($value));
//            }
            $postFields = self::get_byteList($fileMap,$uuid,$body);
        }

        $query = $this->encodeQueryStr($query);
        if ($query != null && $query != "") {
            $url = $url . "?" . $query;
        }

        $body = bin2hex(hash("sha256", $postFields, true));

//      $strsignature = "ctyun-eop-request-id:" . $uuid . "\n" . "eop-date:" . $time . "\n" . "\n" . $query . "\n" . $body;
        $strsignature = "ctyun-eop-request-id:".$uuid."\n"."eop-date:".$time."\n\n".$query."\n".$body;

        $Ktime = $this->en($time, $SecurityKey);

        $kAk = $this->en($accessKey, $Ktime);

        $kdate = $this->en($timeDate, $kAk);

       $signature = base64_encode(($this->en($strsignature, $kdate)));

        print_r($signature);
        $header1 = array(
            'ctyun-eop-request-id:' . $uuid,
            'Eop-Authorization:' . $accessKey . ' Headers=ctyun-eop-request-id;' . 'eop-date Signature=' . $signature,
            'eop-date:' . $time,
        );
        $header = array_merge_recursive($header1, $header, $headers);
        print_r($header);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // 从证书中检查SSL加密算法是否存在
        //print_r($ch);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        switch ($flag) {
            case "GET" :
                curl_setopt($ch, CURLOPT_HTTPGET, true);
                break;
            case "POST":
                print_r($url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
                break;
            case "PUT" :
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
                break;
            case "DELETE":
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
                break;
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);//header请求。如不需要可以去掉
        print_r($ch);
        $response = curl_exec($ch);
        $response = json_decode($response, true);
        print_r($response);
        return $response;

    }

    public function en($str, $pass)
    {
        $ret = (hash_hmac("sha256", ($str), ($pass), true));
        return $ret;
    }

    public function encodeQueryStr($str)
    {
        $afterQuery = "";
        if (!empty($str)) {
            $param = explode("&", $str);
            Var_dump($param);
            sort($param);
            Var_dump($param);
            foreach ($param as $arr) {
                if (strlen($afterQuery) < 1) {
                    $s = explode("=", $arr);
                    Var_dump($s);
                    if (count($s) >= 2) {
                        echo count($s);
                        $encodeStr = "";
                        $encodeStr = urlencode($s[1]);
                        Var_dump($s);
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . $arr;
                    } else {
                        $encodeStr = "";
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . $arr;
                    }
                } else {
                    $s = explode("=", $arr);
                    if (count($s) >= 2) {
                        $encodeStr = urlencode($s[1]);
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . "&" . $arr;
                    } else {
                        $encodeStr = "";
                        $arr = $s[0] . "=" . $encodeStr;
                        $afterQuery = $afterQuery . "&" . $arr;
                    }
                }
            }
        }
        return $afterQuery;
    }

    public static function get_byteList($fileMap,$uuid,$body){
        $byteList = '';
        $contentType = 'multipart/form-data; boundary='.$uuid;
        $boundary = $uuid;
        $boundary = '--'.$boundary;
        $order3 = "\r\n";
        foreach ($fileMap as $key => $value) {
            if (filesize($value) > 1048576) {
                echo "文件过大";
            }
            $body1 = $boundary . "\r\n" .
                "Content-Disposition: form-data; name=\"" . $key . "\"; filename=\"" . basename($value) . "\r\n" .
                "Content-Type: application/octet-stream" . "\r\n" . "\r\n";
            $order1 = ($body1);
            $order2 = (self::readbytes($value));
            $byteList = $byteList . $order1 . $order2 . $order3;
        }

        foreach ($body as $key => $value) {
            $body1 = '--' . $boundary . "\r\n" . "Content-Disposition: form-data; name=" . $key . "\r\n" . "\r\n" . $value . "\r\n";
            $byteList = $byteList. $body1. $order3;
        }
        $byteList = $byteList . $boundary . '--' . $order3;

        return $byteList;
    }

    public static function tostr($bytes) {
        $str = '';
            foreach ($bytes as $ch) {
                $str .= chr($ch);
        }
        return $str;
    }

    public static function readbytes($filename) {

        $handle = fopen($filename,"rb");
        $contents = fread($handle,filesize($filename));
        fclose($handle);
        return $contents;
    }
}
