# input params
param($url, $mode)
Write-Output "url: $url"
Write-Output "mode: $mode"

# current directory
$x = Split-Path -Parent $MyInvocation.MyCommand.Definition
# bucket path
$bucketPath = "cttg"
# second path
$secondPath = "windows"
# related files
$bin = "telegraf.exe"
$conf = "telegraf.conf"
$script = "diskinfo.vbs"
# download timeout seconds
$timeout = 30
# system architecture
$arch = "amd64"
# telegraf path
$dir = "C:\Program Files\ctyuntelegraf\telegraf"
# telegraf installed cached file
$cacheFile = ".installed"
# ctcm-agent zabbix path
$ctcmBinPath = "C:\Windows\ctcm\bin\win64\ctcm_agentd.exe"
$newCtcmBinName = "ctcm_agentd.exe_deprecated"

# mode: 1 update to latest telegraf if not found cached file
# mode: 2 force update to latest telegraf
if ((($mode -eq 1) -and !(Test-Path -Path "$dir\$cacheFile")) -or ($mode -eq 2)) {
    # download telegraf files
    Write-Output "downloading..."
    & "C:\Windows\System32\curl.exe" "$url/$bucketPath/$secondPath/$arch/$bin" -o $bin
    & "C:\Windows\System32\curl.exe" "$url/$bucketPath/$secondPath/$conf" -o $conf
    & "C:\Windows\System32\curl.exe" "$url/$bucketPath/$secondPath/$script" -o $script
    Write-Output "download finished!"

    # uninstall old telegraf
    if (Get-Service ctyuntelegraf -ErrorAction SilentlyContinue) {
        Stop-Service ctyuntelegraf
    }

    if (Test-Path -Path $dir) {
        Set-Location $dir
        # clean telegraf environment variables
        $new = $Env:Path.Replace(";$dir", "")
        [Environment]::SetEnvironmentVariable("PATH", $new, "Machine")
        if (Test-Path -Path .\$bin) {
            & .\$bin --service uninstall --service-name ctyuntelegraf
        }
        Set-Location $x
        Remove-Item -Path $dir -Recurse
    }

    # install latest telegraf
    New-Item -Path $dir -ItemType Directory
    Copy-Item -Path $bin -Destination "$dir\$bin"
    Copy-Item -Path $conf -Destination "$dir\$conf"
    Copy-Item -Path $script -Destination "$dir\$script"
    Set-Location $dir
    & .\$bin --service install --config "$dir\$conf" --service-name ctyuntelegraf --service-display-name ctyuntelegraf
    # set environment variables
    [Environment]::SetEnvironmentVariable("PATH", $Env:Path + ";$dir", "Machine")
    # start service and set service start at startup
    Set-Service ctyuntelegraf -StartupType Automatic
    Start-Service ctyuntelegraf
    # set telegraf installed cached file
    New-Item -Force -Path "$dir\$cacheFile" -ItemType File
    Set-Location $x

    # show telegraf service status
    Get-Service ctyuntelegraf

    # clear tmp files
    Remove-Item $bin -Force
    Remove-Item $conf -Force
    Remove-Item $script -Force
}

# stop zabbix-agent and rename to prevent start
if (Test-Path -Path $ctcmBinPath) {
    & taskkill /f /im ctcm_agentd.exe
    & $ctcmBinPath -x
    & $ctcmBinPath -d
    Rename-Item -Path $ctcmBinPath -NewName $newCtcmBinName
}
