# input params
param($url, $mode)
Write-Output "url: $url"
Write-Output "mode: $mode"

# current directory
$x = Split-Path -Parent $MyInvocation.MyCommand.Definition
# bucket path
$bucketPath = "cttg"
# second path
$secondPath = "windows"
# related files
$bin = "telegraf.exe"
$conf = "telegraf.conf"
$script = "diskinfo.vbs"
$execScript = "exec.ps1"
$binFileSize = "size.txt"
# download timeout seconds
$timeout = 30
# system architecture
$arch = "amd64"
# telegraf path
$dir = "C:\Program Files\ctyuntelegraf\telegraf"
# telegraf installed cached file
$cacheFile = ".installed"
# ctcm-agent zabbix path
$ctcmBinPath = "C:\Windows\ctcm\bin\win64\ctcm_agentd.exe"
$newCtcmBinName = "ctcm_agentd.exe_deprecated"

# mode: 1 update to latest telegraf if not found cached file
# mode: 2 force update to latest telegraf
if ((($mode -eq 1) -and !(Test-Path -Path "$dir\$cacheFile")) -or ($mode -eq 2)) {
    # download telegraf files
    if (Get-Command Invoke-WebRequest -ErrorAction SilentlyContinue) {
        Write-Output "downloading..."
        Invoke-WebRequest -Uri "$url/$bucketPath/$secondPath/$arch/$bin" -TimeoutSec $timeout -OutFile $bin
        Invoke-WebRequest -Uri "$url/$bucketPath/$secondPath/$arch/$binFileSize" -TimeoutSec $timeout -OutFile $binFileSize
        Invoke-WebRequest -Uri "$url/$bucketPath/$secondPath/$script" -TimeoutSec $timeout -OutFile $script
        Invoke-WebRequest -Uri "$url/$bucketPath/$secondPath/$execScript" -TimeoutSec $timeout -OutFile $execScript
        Invoke-WebRequest -Uri "$url/$bucketPath/$secondPath/$conf" -TimeoutSec $timeout -OutFile $conf
        # get size of telegraf.exe unit: bytes
        $file = Get-ChildItem .\$bin
        $binSize = ($file | Measure-Object -Property Length -Sum).Sum
        $size = Get-Content .\$binFileSize
        if ($binSize -eq $size) {
            Write-Output "bin file size equal size:$size"
        }
        else {
            Write-Output "bin file size: $binsize not equal size:$size"
            Exit 1
        }
        Write-Output "download finished!"
    }
    else {
        Write-Output "no command curl(Invoke-WebRequest)"
        Exit 1
    }

    # uninstall old telegraf
    if (Get-Service ctyuntelegraf -ErrorAction SilentlyContinue) {
        Stop-Service ctyuntelegraf
    }

    if (Test-Path -Path $dir) {
        Set-Location $dir
        # clean telegraf environment variables
        $new = $Env:Path.Replace(";$dir", "")
        [Environment]::SetEnvironmentVariable("PATH", $new, "Machine")
        if (Test-Path -Path .\$bin) {
            & .\$bin --service uninstall --service-name ctyuntelegraf
        }
        Set-Location $x
        Remove-Item -Path $dir -Recurse
    }

    # install latest telegraf
    New-Item -Path $dir -ItemType Directory
    Copy-Item -Path $bin -Destination "$dir\$bin"
    Copy-Item -Path $conf -Destination "$dir\$conf"
    Copy-Item -Path $script -Destination "$dir\$script"
    Copy-Item -Path $execScript -Destination "$dir\$execScript"
    Set-Location $dir
    & .\$bin --service install --config "$dir\$conf" --service-name ctyuntelegraf --service-display-name ctyuntelegraf
    # set environment variables
    [Environment]::SetEnvironmentVariable("PATH", $Env:Path + ";$dir", "Machine")
    # start service and set service start at startup
    Set-Service ctyuntelegraf -StartupType Automatic
    Start-Service ctyuntelegraf
    # set telegraf installed cached file
    New-Item -Force -Path "$dir\$cacheFile" -ItemType File
    Set-Location $x

    # show telegraf service status
    Get-Service ctyuntelegraf

    # clear tmp files
    Remove-Item $bin -Force
    Remove-Item $conf -Force
    Remove-Item $script -Force
    Remove-Item $execScript -Force
    Remove-Item $binFileSize -Force
}

# stop zabbix-agent and rename to prevent start
if (Test-Path -Path $ctcmBinPath) {
    & taskkill /f /im ctcm_agentd.exe
    & $ctcmBinPath -x
    & $ctcmBinPath -d
    Rename-Item -Path $ctcmBinPath -NewName $newCtcmBinName
}
