/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.PartETag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

public class UploadCheckPoint
implements Serializable {
    public int md5;
    public String uploadFile;
    public String key;
    public String uploadId;
    public List<Integer> uploadedPartNums;
    public List<PartETag> partETags;
    public FileStat uploadFileStat;
    public long originPartSize;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uploadFile == null ? 0 : this.uploadFile.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.uploadId == null ? 0 : this.uploadId.hashCode());
        result = 31 * result + (this.uploadFileStat == null ? 0 : this.uploadFileStat.hashCode());
        result = 31 * result + (int)this.originPartSize;
        return result;
    }

    public synchronized void load(String cpFile) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(cpFile);
        ObjectInputStream in = new ObjectInputStream(fis);
        UploadCheckPoint ucp = (UploadCheckPoint)in.readObject();
        this.assign(ucp);
        in.close();
        fis.close();
    }

    public synchronized void dump(String cpFile) throws IOException {
        this.md5 = this.hashCode();
        FileOutputStream fos = new FileOutputStream(cpFile);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(this);
        out.close();
        fos.close();
    }

    public void assign(UploadCheckPoint ucp) {
        this.md5 = ucp.md5;
        this.uploadFile = ucp.uploadFile;
        this.key = ucp.key;
        this.uploadId = ucp.uploadId;
        this.uploadedPartNums = ucp.uploadedPartNums;
        this.partETags = ucp.partETags;
        this.uploadFileStat = ucp.uploadFileStat;
        this.originPartSize = ucp.originPartSize;
    }

    public synchronized void update(int partIndex, String etag) throws IOException {
        this.uploadedPartNums.add(partIndex);
        this.partETags.add(new PartETag(partIndex, etag));
    }

    public synchronized boolean isValid(String uploadFile) {
        if (this.md5 != this.hashCode()) {
            return false;
        }
        File upload = new File(uploadFile);
        if (!upload.exists()) {
            return false;
        }
        return this.uploadFile.equals(uploadFile) && this.uploadFileStat.size == upload.length() && this.uploadFileStat.lastModified == upload.lastModified();
    }

    public static class FileStat
    implements Serializable {
        public long size;
        public long lastModified;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            return result;
        }

        public static FileStat getFileStat(String uploadFile) {
            FileStat fileStat = new FileStat();
            File file = new File(uploadFile);
            fileStat.size = file.length();
            fileStat.lastModified = file.lastModified();
            return fileStat;
        }
    }
}

