/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkResults {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: BenchmarkResults result-json-file");
            System.exit(1);
        }
        StringBuilder builder = new StringBuilder();
        File resultsFile = new File(args[0]);
        try (BufferedReader reader = new BufferedReader(new FileReader(resultsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        Server server = new Server(8080);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setBaseResource(Resource.newClassPathResource((String)"/static"));
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new JsonServlet(builder.toString())), "/data");
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        holderPwd.setInitParameter("dirAllowed", "true");
        context.addServlet(holderPwd, "/");
        server.start();
        Desktop.getDesktop().browse(new URI("http://localhost:8080/index.html"));
    }

    public static class JsonServlet
    extends HttpServlet {
        private static final Logger LOGGER = LoggerFactory.getLogger(JsonServlet.class);
        private final String content;

        public JsonServlet(String content) {
            this.content = content;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            try {
                resp.getWriter().append(this.content);
                resp.getWriter().flush();
            }
            catch (IOException e) {
                LOGGER.warn("Error during content writing", (Throwable)e);
            }
        }
    }
}

