/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.CommandLineProxy;
import com.rabbitmq.perf.Metrics;
import com.rabbitmq.perf.NamedThreadFactory;
import com.rabbitmq.perf.PerfTest;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DatadogMetrics
implements Metrics {
    private volatile MeterRegistry registry;

    @Override
    public Options options() {
        Options options = new Options();
        options.addOption(new Option("mda", "metrics-datadog", false, "enable Datadog metrics"));
        options.addOption(new Option("mdk", "metrics-datadog-api-key", true, "Datadog API key"));
        options.addOption(new Option("mds", "metrics-datadog-step-size", true, "step size (reporting frequency) to use in seconds, default is 10 seconds"));
        options.addOption(new Option("mdak", "metrics-datadog-application-key", true, "Datadog application key"));
        options.addOption(new Option("mdh", "metrics-datadog-host-tag", true, "tag that will be mapped to \"host\" when shipping metrics to datadog"));
        options.addOption(new Option("mdd", "metrics-datadog-descriptions", false, "if meter descriptions should be sent to Datadog"));
        options.addOption(new Option("mdu", "metrics-datadog-uri", true, "URI to ship metrics, useful when using a proxy, default is https://app.datadoghq.com"));
        return options;
    }

    @Override
    public void configure(CommandLineProxy cmd, CompositeMeterRegistry meterRegistry, ConnectionFactory factory) throws Exception {
        if (this.isEnabled(cmd)) {
            final HashMap<String, String> dataCfg = new HashMap<String, String>();
            dataCfg.put("datadog.apiKey", PerfTest.strArg(cmd, "mdk", null));
            dataCfg.put("datadog.step", PerfTest.strArg(cmd, "mds", "10"));
            dataCfg.put("datadog.applicationKey", PerfTest.strArg(cmd, "mdak", null));
            dataCfg.put("datadog.hostTag", PerfTest.strArg(cmd, "mdh", null));
            dataCfg.put("datadog.descriptions", Boolean.valueOf(PerfTest.hasOption(cmd, "mdd")).toString());
            dataCfg.put("datadog.uri", PerfTest.strArg(cmd, "mdu", null));
            DatadogConfig config = new DatadogConfig(){

                public Duration step() {
                    return Duration.ofSeconds(Integer.valueOf((String)dataCfg.get("datadog.step")).intValue());
                }

                public String get(String k) {
                    return (String)dataCfg.get(k);
                }
            };
            this.registry = DatadogMeterRegistry.builder((DatadogConfig)config).clock(Clock.SYSTEM).threadFactory((ThreadFactory)new NamedThreadFactory("perf-test-metrics-datadog-")).httpClient((HttpSender)new HttpUrlConnectionSender()).build();
            meterRegistry.add(this.registry);
        }
    }

    @Override
    public void close() {
        if (this.registry != null) {
            this.registry.close();
        }
    }

    public String toString() {
        return "Datadog Metrics";
    }
}

