/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.Log;
import com.rabbitmq.perf.PerfTest;
import com.rabbitmq.perf.Scenario;
import com.rabbitmq.perf.ScenarioFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestMulti {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfTestMulti.class);
    private static final ConnectionFactory factory = new ConnectionFactory();
    private static final Map<String, Object> results = new HashMap<String, Object>();

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: PerfTestMulti input-json-file output-json-file");
            System.exit(1);
        }
        Log.configureLog();
        String inJSON = args[0];
        String outJSON = args[1];
        String json = null;
        try {
            json = PerfTestMulti.readFile(inJSON);
        }
        catch (FileNotFoundException e) {
            System.out.println("Input json file " + inJSON + " could not be found");
            System.exit(1);
        }
        Scenario[] scenarios = PerfTestMulti.scenarios(json, status -> System.exit(status));
        try {
            PerfTestMulti.runStaticBrokerTests(scenarios);
            PerfTestMulti.writeJSON(outJSON);
            System.exit(0);
        }
        catch (Exception e) {
            LOGGER.error("Error during test execution", (Throwable)e);
            System.exit(1);
        }
    }

    static Scenario[] scenarios(String json, PerfTest.SystemExiter systemExiter) {
        Gson gson = new Gson();
        List scenariosJSON = (List)gson.fromJson(json, List.class);
        if (scenariosJSON == null) {
            System.out.println("Input json file could not be parsed");
            systemExiter.exit(1);
        }
        Scenario[] scenarios = new Scenario[scenariosJSON.size()];
        for (int i = 0; i < scenariosJSON.size(); ++i) {
            scenarios[i] = ScenarioFactory.fromJSON((Map)scenariosJSON.get(i), factory);
        }
        return scenarios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String path) throws IOException {
        char[] buf = new char[4096];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");){
            int chars;
            while ((chars = ((Reader)in).read(buf, 0, buf.length)) > 0) {
                out.append(buf, 0, chars);
            }
        }
        return out.toString();
    }

    private static void writeJSON(String outJSON) throws IOException {
        try (FileWriter outFile = new FileWriter(outJSON);
             PrintWriter out = new PrintWriter(outFile);){
            out.println(PerfTestMulti.toJson(results));
        }
    }

    static String toJson(Object object) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(object);
    }

    private static void runStaticBrokerTests(Scenario[] scenarios) throws Exception {
        PerfTestMulti.runTests(scenarios);
    }

    private static void runTests(Scenario[] scenarios) throws Exception {
        for (Scenario scenario : scenarios) {
            System.out.print("Running scenario '" + scenario.getName() + "' ");
            scenario.run();
            System.out.println();
            results.put(scenario.getName(), scenario.getStats().results());
        }
    }
}

