/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.CommandLineProxy;
import com.rabbitmq.perf.Metrics;
import com.rabbitmq.perf.PerfTest;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class PrometheusMetrics
implements Metrics {
    private volatile Server server;
    private volatile PrometheusMeterRegistry registry;

    @Override
    public Options options() {
        Options options = new Options();
        options.addOption(new Option("mpr", "metrics-prometheus", false, "enable Prometheus metrics"));
        options.addOption(new Option("mpe", "metrics-prometheus-endpoint", true, "the HTTP metrics endpoint, default is /metrics"));
        options.addOption(new Option("mpp", "metrics-prometheus-port", true, "the port to launch the HTTP metrics endpoint on, default is 8080"));
        return options;
    }

    @Override
    public void configure(CommandLineProxy cmd, CompositeMeterRegistry meterRegistry, ConnectionFactory factory) throws Exception {
        if (this.isEnabled(cmd)) {
            this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            meterRegistry.add((MeterRegistry)this.registry);
            int prometheusHttpEndpointPort = PerfTest.intArg(cmd, "mpp", 8080);
            String prometheusHttpEndpoint = PerfTest.strArg(cmd, "mpe", "metrics");
            prometheusHttpEndpoint = prometheusHttpEndpoint.startsWith("/") ? prometheusHttpEndpoint : "/" + prometheusHttpEndpoint;
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setMinThreads(2);
            threadPool.setMaxThreads(12);
            this.server = new Server((ThreadPool)threadPool);
            ServerConnector connector = new ServerConnector(this.server);
            connector.setPort(prometheusHttpEndpointPort);
            this.server.setConnectors(new Connector[]{connector});
            ContextHandler context = new ContextHandler();
            context.setContextPath(prometheusHttpEndpoint);
            context.setHandler((Handler)new AbstractHandler(){

                public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse response) throws IOException {
                    String scraped = PrometheusMetrics.this.registry.scrape();
                    response.setStatus(200);
                    response.setContentLength(scraped.length());
                    response.setContentType("text/plain");
                    response.getWriter().print(scraped);
                    request.setHandled(true);
                }
            });
            this.server.setHandler((Handler)context);
            this.server.setStopTimeout(1000L);
            this.server.start();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.registry != null) {
            this.registry.close();
        }
    }

    public String toString() {
        return "Prometheus Metrics";
    }
}

