/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.MulticastVariable;
import com.rabbitmq.perf.Scenario;
import com.rabbitmq.perf.ScenarioStats;
import com.rabbitmq.perf.SimpleScenario;
import com.rabbitmq.perf.SimpleScenarioStats;
import com.rabbitmq.perf.VaryingScenario;

public class RateVsLatencyScenario
implements Scenario {
    private final String name;
    private final ConnectionFactory factory;
    private final MulticastParams params;
    private VaryingScenario impl;

    public RateVsLatencyScenario(String name, ConnectionFactory factory, MulticastParams params) {
        this.name = name;
        this.factory = factory;
        this.params = params;
    }

    @Override
    public void run() throws Exception {
        SimpleScenario s = new SimpleScenario("untitled", this.factory, this.params);
        s.run();
        SimpleScenarioStats m = s.getStats();
        int maxRate = (int)(m.getRecvRate() + m.getSendRate()) / 2;
        Double[] factors = new Double[]{0.01, 0.2, 0.4, 0.6, 0.8, 0.9, 0.95, 0.96, 0.97, 0.98, 0.99, 1.0, 1.01, 1.02, 1.03, 1.04, 1.05};
        Integer[] rates = new Integer[factors.length];
        for (int i = 0; i < rates.length; ++i) {
            rates[i] = (int)(factors[i] * (double)maxRate);
        }
        this.impl = new VaryingScenario("untitled", this.factory, this.params, new MulticastVariable("producerRateLimit", rates));
        this.impl.run();
    }

    @Override
    public ScenarioStats getStats() {
        return this.impl.getStats();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

