/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownService
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownService.class);
    private final List<AutoCloseable> closeables = Collections.synchronizedList(new ArrayList());

    AutoCloseable wrap(CloseCallback closeCallback) {
        AtomicBoolean closingOrAlreadyClosed = new AtomicBoolean(false);
        AutoCloseable idempotentCloseCallback = () -> {
            if (closingOrAlreadyClosed.compareAndSet(false, true)) {
                closeCallback.run();
            }
        };
        this.closeables.add(idempotentCloseCallback);
        return idempotentCloseCallback;
    }

    @Override
    public void close() {
        if (this.closeables.size() > 0) {
            for (int i = this.closeables.size() - 1; i >= 0; --i) {
                try {
                    this.closeables.get(i).close();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Could not properly closed {}", (Object)this.closeables.get(i), (Object)e);
                }
            }
        }
    }

    @FunctionalInterface
    static interface CloseCallback {
        public void run() throws Exception;
    }
}

