/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.MulticastSet;
import com.rabbitmq.perf.PerfTest;
import com.rabbitmq.perf.Scenario;
import com.rabbitmq.perf.SimpleScenarioStats;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class SimpleScenario
implements Scenario {
    private final String name;
    private final ConnectionFactory factory;
    private final MulticastParams[] params;
    private final long interval;
    private SimpleScenarioStats stats;

    public SimpleScenario(String name, ConnectionFactory factory, MulticastParams ... params) {
        this(name, factory, 1000L, params);
    }

    public SimpleScenario(String name, ConnectionFactory factory, long interval, MulticastParams ... params) {
        this.name = name;
        this.factory = factory;
        this.params = params;
        this.interval = interval;
    }

    @Override
    public void run() throws IOException, InterruptedException, TimeoutException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException, ExecutionException {
        this.stats = new SimpleScenarioStats(this.interval);
        for (MulticastParams p : this.params) {
            MulticastSet set = new MulticastSet(this.stats, this.factory, p, null, PerfTest.getCompletionHandler(p));
            this.stats.setup(p);
            set.run();
        }
    }

    @Override
    public SimpleScenarioStats getStats() {
        return this.stats;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

