/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;

public abstract class Stats {
    protected final long interval;
    protected final long startTime;
    private final Consumer<Long> updateLatency;
    private final Consumer<Long> updateConfirmLatency;
    private final DoubleAccumulator published;
    private final DoubleAccumulator returned;
    private final DoubleAccumulator confirmed;
    private final DoubleAccumulator nacked;
    private final DoubleAccumulator consumed;
    protected long lastStatsTime;
    protected int sendCountInterval;
    protected int returnCountInterval;
    protected int confirmCountInterval;
    protected int nackCountInterval;
    protected int recvCountInterval;
    protected int sendCountTotal;
    protected int recvCountTotal;
    protected int latencyCountInterval;
    protected int latencyCountTotal;
    protected long minLatency;
    protected long maxLatency;
    protected long cumulativeLatencyInterval;
    protected long cumulativeLatencyTotal;
    protected long elapsedInterval;
    protected long elapsedTotal;
    protected Histogram latency = new MetricRegistry().histogram("latency");
    protected Histogram confirmLatency = new MetricRegistry().histogram("confirm-latency");

    public Stats(long interval) {
        this(interval, false, (MeterRegistry)new SimpleMeterRegistry(), null);
    }

    public Stats(long interval, boolean useMs, MeterRegistry registry, String metricsPrefix) {
        this.interval = interval;
        this.startTime = System.currentTimeMillis();
        metricsPrefix = metricsPrefix == null ? "" : metricsPrefix;
        Timer latencyTimer = Timer.builder((String)(metricsPrefix + "latency")).description("message latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofMillis(this.interval)).sla(new Duration[0]).register(registry);
        Timer confirmLatencyTimer = Timer.builder((String)(metricsPrefix + "confirm.latency")).description("confirm latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofMillis(this.interval)).sla(new Duration[0]).register(registry);
        DoubleBinaryOperator accumulatorFunction = (x, y) -> y;
        this.published = (DoubleAccumulator)registry.gauge(metricsPrefix + "published", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.returned = (DoubleAccumulator)registry.gauge(metricsPrefix + "returned", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.confirmed = (DoubleAccumulator)registry.gauge(metricsPrefix + "confirmed", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.nacked = (DoubleAccumulator)registry.gauge(metricsPrefix + "nacked", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.consumed = (DoubleAccumulator)registry.gauge(metricsPrefix + "consumed", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.updateLatency = useMs ? latency -> latencyTimer.record(latency.longValue(), TimeUnit.MILLISECONDS) : latency -> latencyTimer.record(latency.longValue(), TimeUnit.NANOSECONDS);
        this.updateConfirmLatency = useMs ? latency -> confirmLatencyTimer.record(latency.longValue(), TimeUnit.MILLISECONDS) : latency -> confirmLatencyTimer.record(latency.longValue(), TimeUnit.NANOSECONDS);
        this.reset(this.startTime);
    }

    private void reset(long t) {
        this.lastStatsTime = t;
        this.sendCountInterval = 0;
        this.returnCountInterval = 0;
        this.confirmCountInterval = 0;
        this.nackCountInterval = 0;
        this.recvCountInterval = 0;
        this.minLatency = Long.MAX_VALUE;
        this.maxLatency = Long.MIN_VALUE;
        this.latencyCountInterval = 0;
        this.cumulativeLatencyInterval = 0L;
        this.latency = new MetricRegistry().histogram("latency");
        this.confirmLatency = new MetricRegistry().histogram("confirm-latency");
    }

    private void report() {
        long now = System.currentTimeMillis();
        this.elapsedInterval = now - this.lastStatsTime;
        if (this.elapsedInterval >= this.interval) {
            this.elapsedTotal += this.elapsedInterval;
            this.report(now);
            this.reset(now);
        }
    }

    protected abstract void report(long var1);

    public synchronized void handleSend() {
        ++this.sendCountInterval;
        ++this.sendCountTotal;
        this.report();
    }

    public synchronized void handleReturn() {
        ++this.returnCountInterval;
        this.report();
    }

    public synchronized void handleConfirm(int numConfirms, long[] latencies) {
        this.confirmCountInterval += numConfirms;
        for (long latency : latencies) {
            this.confirmLatency.update(latency);
            this.updateConfirmLatency.accept(latency);
        }
        this.report();
    }

    public synchronized void handleNack(int numAcks) {
        this.nackCountInterval += numAcks;
        this.report();
    }

    public synchronized void handleRecv(long latency) {
        ++this.recvCountInterval;
        ++this.recvCountTotal;
        if (latency > 0L) {
            this.latency.update(latency);
            this.updateLatency.accept(latency);
            this.minLatency = Math.min(this.minLatency, latency);
            this.maxLatency = Math.max(this.maxLatency, latency);
            this.cumulativeLatencyInterval += latency;
            this.cumulativeLatencyTotal += latency;
            ++this.latencyCountInterval;
            ++this.latencyCountTotal;
        }
        this.report();
    }

    protected void published(double rate) {
        this.published.accumulate(rate);
    }

    protected void returned(double rate) {
        this.returned.accumulate(rate);
    }

    protected void confirmed(double rate) {
        this.confirmed.accumulate(rate);
    }

    protected void nacked(double rate) {
        this.nacked.accumulate(rate);
    }

    protected void received(double rate) {
        this.consumed.accumulate(rate);
    }
}

