/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

public class TimestampProvider {
    private final boolean useMillis;
    private final boolean isTimestampInHeader;

    public TimestampProvider(boolean useMillis, boolean isTimestampInHeader) {
        this.useMillis = useMillis;
        this.isTimestampInHeader = isTimestampInHeader;
    }

    public boolean isTimestampInHeader() {
        return this.isTimestampInHeader;
    }

    public long getCurrentTime() {
        if (this.useMillis) {
            return System.currentTimeMillis();
        }
        return System.nanoTime();
    }

    public long getDifference(long ts1, long ts2) {
        return Math.abs(ts1 - ts2);
    }
}

