/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyRecording {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyRecording.class);
    private final ConcurrentMap<String, RecordedExchange> exchanges = new ConcurrentHashMap<String, RecordedExchange>();
    private final ConcurrentMap<String, RecordedQueue> queues = new ConcurrentHashMap<String, RecordedQueue>();
    private final Collection<RecordedBinding> bindings = new CopyOnWriteArrayList<RecordedBinding>();
    private final Collection<TopologyRecording> children = new CopyOnWriteArrayList<TopologyRecording>();
    private final boolean polling;

    public TopologyRecording(boolean polling) {
        this.polling = polling;
    }

    private static Channel reliableWrite(Connection connection, Channel channel, WriteOperation operation) throws IOException {
        try {
            operation.write(channel);
            return channel;
        }
        catch (Exception e) {
            LOGGER.warn("Error during topology recovery: {}", (Object)e.getMessage());
            return connection.createChannel();
        }
    }

    TopologyRecording child() {
        TopologyRecording child = new TopologyRecording(this.polling);
        this.children.add(child);
        return child;
    }

    Collection<RecordedQueue> queues() {
        ArrayList<RecordedQueue> queues = new ArrayList<RecordedQueue>(this.queues.values());
        for (TopologyRecording child : this.children) {
            queues.addAll(child.queues());
        }
        return queues;
    }

    public RecordedExchange recordExchange(String name, String type) {
        this.exchanges.putIfAbsent(name, new RecordedExchange(name, type));
        return (RecordedExchange)this.exchanges.get(name);
    }

    public RecordedQueue recordQueue(String name, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments, boolean serverNamed) {
        this.queues.putIfAbsent(name, new RecordedQueue(name, durable, exclusive, autoDelete, arguments, serverNamed));
        return (RecordedQueue)this.queues.get(name);
    }

    public RecordedBinding recordBinding(String queue, String exchange, String routingKey) {
        RecordedBinding binding = new RecordedBinding(queue, exchange, routingKey);
        this.bindings.add(binding);
        return binding;
    }

    public RecordedQueue queue(String name) {
        return (RecordedQueue)this.queues.get(name);
    }

    public RecordedExchange exchange(String name) {
        return (RecordedExchange)this.exchanges.get(name);
    }

    private Collection<RecordedBinding> getBindingsFor(String queue) {
        return this.bindings.stream().filter(b -> ((RecordedBinding)b).queue.equals(queue)).collect(Collectors.toList());
    }

    public TopologyRecording subRecording(Collection<String> queues) {
        TopologyRecording clientTopologyRecording = this.child();
        for (String queue : queues) {
            clientTopologyRecording.queues.putIfAbsent(queue, (RecordedQueue)this.queues.get(queue));
            for (RecordedBinding binding : this.getBindingsFor(queue)) {
                clientTopologyRecording.bindings.add(binding);
                clientTopologyRecording.exchanges.put(binding.getExchange(), (RecordedExchange)this.exchanges.get(binding.getExchange()));
            }
        }
        return clientTopologyRecording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Connection connection) {
        try {
            RecordedQueue recordedQueue;
            RecordedQueue queue;
            Channel channel = connection.createChannel();
            for (Map.Entry entry : this.queues.entrySet()) {
                recordedQueue = queue = (RecordedQueue)entry.getValue();
                synchronized (recordedQueue) {
                    String originalName = queue.name;
                    LOGGER.debug("Connection {}, recovering queue {}", (Object)connection.getClientProvidedName(), (Object)queue);
                    channel = TopologyRecording.reliableWrite(connection, channel, ch -> {
                        String newName = ch.queueDeclare(queue.serverNamed ? "" : queue.name, queue.durable, queue.exclusive, queue.autoDelete, queue.arguments).getQueue();
                        queue.name = newName;
                    });
                    LOGGER.debug("Connection {}, recovered queue {}", (Object)connection.getClientProvidedName(), (Object)queue);
                    if (this.polling && queue.autoDelete && queue.serverNamed && !queue.exclusive) {
                        channel = TopologyRecording.reliableWrite(connection, channel, ch -> ch.queueDelete(originalName));
                    }
                }
            }
            for (RecordedExchange exchange : this.exchanges.values()) {
                LOGGER.debug("Connection {}, recovering exchange {}", (Object)connection.getClientProvidedName(), (Object)exchange);
                channel = TopologyRecording.reliableWrite(connection, channel, ch -> ch.exchangeDeclare(exchange.name, exchange.type));
                LOGGER.debug("Connection {}, recovered exchange {}", (Object)connection.getClientProvidedName(), (Object)exchange);
            }
            for (RecordedBinding binding : this.bindings) {
                LOGGER.debug("Connection {}, recovering binding {}", (Object)connection.getClientProvidedName(), (Object)binding);
                recordedQueue = queue = (RecordedQueue)this.queues.get(binding.queue);
                synchronized (recordedQueue) {
                    channel = TopologyRecording.reliableWrite(connection, channel, ch -> ch.queueBind(queue.name, binding.exchange, binding.routingKeyIsQueue() ? queue.name : binding.routingKey));
                }
                LOGGER.debug("Connection {}, recovered binding {}", (Object)connection.getClientProvidedName(), (Object)binding);
            }
            channel.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error during topology recovery for connection {}: {}", (Object)connection.getClientProvidedName(), (Object)e.getMessage());
        }
    }

    class RecordedBinding {
        private final String queue;
        private final String exchange;
        private final String routingKey;

        RecordedBinding(String queue, String exchange, String routingKey) {
            this.queue = queue;
            this.exchange = exchange;
            this.routingKey = routingKey;
        }

        public String getExchange() {
            return this.exchange;
        }

        public boolean routingKeyIsQueue() {
            return this.queue.equals(this.routingKey);
        }

        public String toString() {
            return "RecordedBinding{queue='" + this.queue + '\'' + ", exchange='" + this.exchange + '\'' + ", routingKey='" + this.routingKey + '\'' + '}';
        }
    }

    class RecordedQueue {
        private final boolean durable;
        private final boolean exclusive;
        private final boolean autoDelete;
        private final Map<String, Object> arguments;
        private final boolean serverNamed;
        private String name;

        public RecordedQueue(String name, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments, boolean serverNamed) {
            this.name = name;
            this.durable = durable;
            this.exclusive = exclusive;
            this.autoDelete = autoDelete;
            this.arguments = arguments;
            this.serverNamed = serverNamed;
        }

        public String name() {
            return this.name;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public boolean isServerNamed() {
            return this.serverNamed;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public String toString() {
            return "RecordedQueue{name='" + this.name + '\'' + ", durable=" + this.durable + ", exclusive=" + this.exclusive + ", autoDelete=" + this.autoDelete + ", arguments=" + this.arguments + ", serverNamed=" + this.serverNamed + '}';
        }
    }

    class RecordedExchange {
        private final String name;
        private final String type;

        RecordedExchange(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "RecordedExchange{name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    @FunctionalInterface
    private static interface WriteOperation {
        public void write(Channel var1) throws IOException;
    }
}

