/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.ValueIndicator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VariableValueIndicator<T>
implements ValueIndicator<T> {
    public static final int NANO_TO_SECOND = 1000000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableValueIndicator.class);
    private final ScheduledExecutorService scheduledExecutorService;
    private final List<Interval<T>> intervals;
    private final AtomicReference<T> value = new AtomicReference();
    private final List<String> definitions;

    public VariableValueIndicator(List<String> values, ScheduledExecutorService scheduledExecutorService, Function<String, T> conversion) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (String value : values) {
            VariableValueIndicator.validate(value);
        }
        this.scheduledExecutorService = scheduledExecutorService;
        this.definitions = new ArrayList<String>(values);
        this.intervals = VariableValueIndicator.intervals(values, conversion);
        this.value.set(this.intervals.get((int)0).value);
    }

    static <T> void updateValueIfNecessary(List<Interval<T>> intervals, long startTime, long now, int cycleDuration, AtomicReference<T> value) {
        long elapsed = (now - startTime) / 1000000000L % (long)cycleDuration;
        for (Interval<T> interval : intervals) {
            if (!interval.isIn(elapsed)) continue;
            if (value.get().equals(interval.value)) break;
            value.set(interval.value);
            break;
        }
    }

    static void validate(String definition) throws IllegalArgumentException {
        AtomicBoolean valid = new AtomicBoolean(true);
        if (definition == null || definition.isEmpty() || !definition.contains(":")) {
            valid.set(false);
        }
        String[] valueAndDuration = null;
        if (valid.get() && (valueAndDuration = definition.split(":")).length != 2) {
            valid.set(false);
        }
        if (valid.get()) {
            Arrays.asList({valueAndDuration[0], value -> value >= 0}, {valueAndDuration[1], value -> value > 0}).forEach(parameters -> {
                String input = parameters[0].toString();
                Predicate validation = (Predicate)parameters[1];
                try {
                    int value = Integer.valueOf(input);
                    if (!validation.test(value)) {
                        valid.set(false);
                    }
                }
                catch (NumberFormatException e) {
                    valid.set(false);
                }
            });
        }
        if (!valid.get()) {
            throw new IllegalArgumentException("Invalid variable value definition: " + definition + ". Should be [VALUE]:[DURATION] with VALUE integer >= 0 and DURATION integer > 0");
        }
    }

    private static int gcd(int a, int b) {
        if (a == 0) {
            return b;
        }
        return VariableValueIndicator.gcd(b % a, a);
    }

    static int gcd(int[] arr, int n) {
        int result = arr[0];
        for (int i = 1; i < n; ++i) {
            result = VariableValueIndicator.gcd(arr[i], result);
        }
        return result;
    }

    static <T> List<Interval<T>> intervals(List<String> values, Function<String, T> conversion) {
        ArrayList<Interval<T>> intervals = new ArrayList<Interval<T>>(values.size());
        int start = 0;
        for (String value : values) {
            VariableValueIndicator.validate(value);
            String[] valueAndDuration = value.split(":");
            int duration = Integer.valueOf(valueAndDuration[1]);
            int end = start + duration;
            Interval<T> interval = new Interval<T>(start, end, conversion.apply(valueAndDuration[0]));
            intervals.add(interval);
            start = end;
        }
        return intervals;
    }

    @Override
    public T getValue() {
        return this.value.get();
    }

    @Override
    public void start() {
        int[] durations = new int[this.definitions.size()];
        for (int i = 0; i < this.definitions.size(); ++i) {
            String[] valueAndDuration = this.definitions.get(i).split(":");
            durations[i] = Integer.valueOf(valueAndDuration[1]);
        }
        int cycleDuration = this.intervals.get((int)(this.intervals.size() - 1)).end;
        int gcdSchedulingPeriod = 1;
        try {
            gcdSchedulingPeriod = VariableValueIndicator.gcd(durations, durations.length);
        }
        catch (Exception e) {
            LOGGER.warn("Error while calculating GCD: " + e.getMessage() + ". Falling back to 1-second scheduling.");
        }
        long startTime = System.nanoTime();
        this.scheduledExecutorService.scheduleAtFixedRate(() -> VariableValueIndicator.updateValueIfNecessary(this.intervals, startTime, System.nanoTime(), cycleDuration, this.value), 0L, gcdSchedulingPeriod, TimeUnit.SECONDS);
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    @Override
    public List<T> values() {
        return this.intervals.stream().map(interval -> interval.value).collect(Collectors.toList());
    }

    static class Interval<T> {
        final int start;
        final int end;
        final T value;

        Interval(int start, int end, T value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }

        boolean isIn(long value) {
            return value >= (long)this.start && value < (long)this.end;
        }

        public String toString() {
            return "Interval{start=" + this.start + ", end=" + this.end + ", value=" + this.value + '}';
        }
    }
}

