/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebServer {
    public static void main(String[] args) throws Exception {
        if (args.length != 0 && args.length != 2) {
            System.out.println("Usage: WebServer [baseDirectory] [port]");
            System.exit(1);
        }
        String baseDirectory = "./html";
        int port = 8080;
        if (args.length == 2) {
            baseDirectory = args[0];
            port = Integer.valueOf(args[1]);
        }
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        Server server = new Server(port);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setResourceBase(baseDirectory);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        holderPwd.setInitParameter("dirAllowed", "true");
        context.addServlet(holderPwd, "/");
        server.start();
    }
}

