/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools;

import com.rabbitmq.client.impl.NetworkConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Host {
    public static String capture(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder buff = new StringBuilder();
        while ((line = br.readLine()) != null) {
            buff.append(line).append("\n");
        }
        return buff.toString();
    }

    public static Process executeCommand(String command) throws IOException {
        Process pr = Host.executeCommandProcess(command);
        int ev = Host.waitForExitValue(pr);
        if (ev != 0) {
            String stdout = Host.capture(pr.getInputStream());
            String stderr = Host.capture(pr.getErrorStream());
            throw new IOException("unexpected command exit value: " + ev + "\ncommand: " + command + "\n\nstdout:\n" + stdout + "\nstderr:\n" + stderr + "\n");
        }
        return pr;
    }

    private static int waitForExitValue(Process pr) {
        while (true) {
            try {
                pr.waitFor();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return pr.exitValue();
    }

    public static Process executeCommandIgnoringErrors(String command) throws IOException {
        Process pr = Host.executeCommandProcess(command);
        Host.waitForExitValue(pr);
        return pr;
    }

    private static Process executeCommandProcess(String command) throws IOException {
        String[] finalCommand = System.getProperty("os.name").toLowerCase().contains("windows") ? new String[]{"C:\\winnt\\system32\\cmd.exe", "/y", "/c", command} : new String[]{"/bin/sh", "-c", command};
        return Runtime.getRuntime().exec(finalCommand);
    }

    public static Process rabbitmqctl(String command) throws IOException {
        return Host.executeCommand(Host.rabbitmqctlCommand() + " -n '" + Host.nodenameA() + "' " + command);
    }

    public static Process rabbitmqctlIgnoreErrors(String command) throws IOException {
        return Host.executeCommandIgnoringErrors(Host.rabbitmqctlCommand() + " -n '" + Host.nodenameA() + "' " + command);
    }

    public static Process invokeMakeTarget(String command) throws IOException {
        File rabbitmqctl = new File(Host.rabbitmqctlCommand());
        return Host.executeCommand(Host.makeCommand() + " -C '" + Host.rabbitmqDir() + "' RABBITMQCTL='" + rabbitmqctl.getAbsolutePath() + "' RABBITMQ_NODENAME='" + Host.nodenameA() + "' RABBITMQ_NODE_PORT=" + Host.node_portA() + " RABBITMQ_CONFIG_FILE='" + Host.config_fileA() + "' " + command);
    }

    public static String makeCommand() {
        return System.getProperty("make.bin", "make");
    }

    public static String nodenameA() {
        return System.getProperty("test-broker.A.nodename");
    }

    public static String node_portA() {
        return System.getProperty("test-broker.A.node_port");
    }

    public static String config_fileA() {
        return System.getProperty("test-broker.A.config_file");
    }

    public static String nodenameB() {
        return System.getProperty("test-broker.B.nodename");
    }

    public static String node_portB() {
        return System.getProperty("test-broker.B.node_port");
    }

    public static String config_fileB() {
        return System.getProperty("test-broker.B.config_file");
    }

    public static String rabbitmqctlCommand() {
        return System.getProperty("rabbitmqctl.bin");
    }

    public static String rabbitmqDir() {
        return System.getProperty("rabbitmq.dir");
    }

    public static void closeConnection(String pid) throws IOException {
        Host.rabbitmqctl("close_connection '" + pid + "' 'Closed via rabbitmqctl'");
    }

    public static void closeConnection(NetworkConnection c) throws IOException {
        ConnectionInfo ci = Host.findConnectionInfoFor(Host.listConnections(), c);
        if (ci != null) {
            Host.closeConnection(ci.getPid());
        }
    }

    public static List<ConnectionInfo> listConnections() throws IOException {
        String output = Host.capture(Host.rabbitmqctl("list_connections -q pid peer_port").getInputStream());
        String[] allLines = output.split("\n");
        ArrayList<ConnectionInfo> result = new ArrayList<ConnectionInfo>();
        for (String line : allLines) {
            String[] columns = line.split("\t");
            result.add(new ConnectionInfo(columns[0], Integer.valueOf(columns[1])));
        }
        return result;
    }

    private static ConnectionInfo findConnectionInfoFor(List<ConnectionInfo> xs, NetworkConnection c) {
        ConnectionInfo result = null;
        for (ConnectionInfo ci : xs) {
            if (c.getLocalPort() != ci.getPeerPort()) continue;
            result = ci;
            break;
        }
        return result;
    }

    public static class ConnectionInfo {
        private final String pid;
        private final int peerPort;

        public ConnectionInfo(String pid, int peerPort) {
            this.pid = pid;
            this.peerPort = peerPort;
        }

        public String getPid() {
            return this.pid;
        }

        public int getPeerPort() {
            return this.peerPort;
        }
    }
}

