/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk.security;

import com.ffcs.ebp.ebpsdk.security.RandomFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class UUIDUtils {
    private static long b = 1180000000000L;
    private static long seedUniquifier = System.currentTimeMillis() - b;
    private static final int DEFAULT_RADIX = 36;
    private static final String[] letters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String getUniqueId(int length, int radix) {
        String uniqueId;
        int initialLength;
        int leftLength;
        if ((leftLength = (initialLength = (uniqueId = Long.toString(++seedUniquifier, radix)).length()) - length) > 0) {
            uniqueId = uniqueId.substring(leftLength, initialLength);
        } else if (leftLength < 0) {
            StringBuilder buffer = new StringBuilder();
            while (leftLength < 0) {
                String rand = UUIDUtils.rand();
                buffer.append(rand);
                ++leftLength;
            }
            buffer.append(uniqueId);
            uniqueId = buffer.toString();
        }
        return uniqueId;
    }

    public static String getUniqueId(int length) {
        return UUIDUtils.getUniqueId(length, 36);
    }

    public static String getUniqueId() {
        return UUIDUtils.getUniqueId(8);
    }

    public static String uuid() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }

    public static String rand() {
        int random = RandomFactory.nextInt();
        int index = Math.abs(random % 62);
        return letters[index];
    }

    public static int getRand(int length) {
        int random = RandomFactory.getInstance().nextInt();
        int index = Math.abs(random % length);
        return index;
    }

    public static String generateRandom(int length) {
        String result = "";
        for (int i = 0; i < length; ++i) {
            String random = String.valueOf(UUIDUtils.getRand(10));
            result = result + random;
        }
        return result;
    }

    public static String randomMorningTime(int t) {
        StringBuffer sb = new StringBuffer();
        if (t == 0) {
            int left = UUIDUtils.myRandom(0, 1);
            sb.append(left);
            if (left == 0) {
                sb.append("9");
            }
            if (left == 1) {
                sb.append("0");
            }
        }
        if (t == 1) {
            sb.append("1");
            sb.append(UUIDUtils.myRandom(1, 2));
        }
        if (t == 2) {
            sb.append(UUIDUtils.myRandom(17, 18));
        }
        sb.append(":");
        sb.append(UUIDUtils.myRandom(0, 5));
        sb.append(UUIDUtils.myRandom(0, 9));
        return sb.toString();
    }

    public static int myRandom(int m, int n) {
        if (m > n) {
            return 0;
        }
        int reVal = (int)(RandomFactory.nextDouble() * (double)(n - m + 1)) + m;
        return reVal;
    }

    public static String getRandomTime(String beginTime, String endTime) {
        String date = "";
        try {
            Date beginDate = null;
            Date endDate = null;
            if (beginTime.length() == 10) {
                beginDate = new SimpleDateFormat("yyyy-MM-dd").parse(beginTime);
                endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endTime);
            } else {
                beginDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(beginTime);
                endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
            }
            long le = endDate.getTime();
            long lb = beginDate.getTime();
            long random = Math.round(RandomFactory.nextDouble() * (double)(le - lb) + (double)lb);
            SimpleDateFormat fm1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = fm1.format(random);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String randXXXnumber(int length) {
        StringBuffer sb = new StringBuffer();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                sb.append((char)UUIDUtils.randInt(48, 57));
            }
        }
        return sb.toString();
    }

    private static int randInt() {
        return RandomFactory.nextInt();
    }

    private static int randInt(int start, int end) {
        if (start > end) {
            UUIDUtils.swap(start, end);
        }
        return Math.abs(UUIDUtils.randInt() % (end - start + 1)) + start;
    }

    private static void swap(int a, int b) {
    }
}

