/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk;

import com.ffcs.ebp.ebpsdk.Header;
import com.ffcs.ebp.ebpsdk.HttpRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class EbpContext {
    private final String protocols = "http://";
    private String requestUrl;
    private String clientIp = HttpRequest.getLocalHostLANAddress().getHostAddress();
    private String params;
    private List<Header> headers = new ArrayList<Header>();

    EbpContext() {
    }

    public EbpContext(String url, Header ... headers) {
        this.requestUrl = url;
        this.headers.addAll(Arrays.asList(headers));
    }

    public EbpContext(String url, List<Header> headers) {
        this.requestUrl = url;
        this.headers = headers;
    }

    String getClientIp() {
        if (StringUtils.isBlank(this.clientIp)) {
            throw new RuntimeException("ORIG_CLIENT_IP\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!this.isIP(this.clientIp)) {
            throw new RuntimeException("ORIG_CLIENT_IP,\u683c\u5f0f\u9519\u8bef\uff01");
        }
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getParams() {
        try {
            if (StringUtils.isBlank(this.params)) {
                throw new RuntimeException("\u8bf7\u6c42\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            JSONObject.fromObject(this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bf7\u6c42\u62a5\u6587\u683c\u5f0f\u5fc5\u987b\u4e3aJson\u683c\u5f0f");
        }
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    private boolean isIP(String addr) {
        if (StringUtils.isNotBlank(addr) && addr.length() >= 7 && addr.length() <= 15) {
            String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
            Pattern pat = Pattern.compile(rexp);
            Matcher mat = pat.matcher(addr);
            return mat.find();
        }
        return false;
    }

    String getRequestUrl() {
        if (StringUtils.isBlank(this.requestUrl)) {
            throw new NullPointerException("API\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.requestUrl.endsWith("/") ? this.requestUrl : this.requestUrl.concat("/");
    }
}

