/*
 * Decompiled with CFR 0.152.
 */
package com.ffcs.ebp.ebpsdk.security;

import com.ffcs.ebp.ebpsdk.security.AuthBase64Utils;
import com.ffcs.ebp.ebpsdk.security.HexByteUtil;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.crypto.Cipher;

public class AuthRSAUtils {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String TRANSFORMATION_NAME = "RSA/ECB/PKCS1Padding";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = AuthBase64Utils.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateK);
        signature.update(data);
        return AuthBase64Utils.encode(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = AuthBase64Utils.decode(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicK);
        signature.update(data);
        return signature.verify(AuthBase64Utils.decode(sign));
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
        byte[] keyBytes = AuthBase64Utils.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
        cipher.init(2, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static String decryptByPrivateKeyStr(String encryptedDataStr, String privateKey) throws Exception {
        byte[] encryptedData = HexByteUtil.hexStr2ByteArr(encryptedDataStr);
        String str = new String(AuthRSAUtils.decryptByPrivateKey(encryptedData, privateKey), DEFAULT_CHARSET_NAME);
        return str;
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
        byte[] keyBytes = AuthBase64Utils.decode(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
        cipher.init(2, publicK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static String decryptByPublicKeyStr(String encryptedDataStr, String publicKey) throws Exception {
        byte[] encryptedData = HexByteUtil.hexStr2ByteArr(encryptedDataStr);
        String str = new String(AuthRSAUtils.decryptByPublicKey(encryptedData, publicKey), DEFAULT_CHARSET_NAME);
        return str;
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = AuthBase64Utils.decode(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
        cipher.init(1, publicK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String encryptByPublicKeyStr(String dataStr, String publicKey) throws Exception {
        byte[] data = dataStr.getBytes(DEFAULT_CHARSET_NAME);
        String encryptedDateStr = HexByteUtil.byteArr2HexStr(AuthRSAUtils.encryptByPublicKey(data, publicKey));
        return encryptedDateStr;
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = AuthBase64Utils.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
        cipher.init(1, privateK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String encryptByPrivateKeyStr(String dataStr, String privateKey) throws Exception {
        byte[] data = dataStr.getBytes(DEFAULT_CHARSET_NAME);
        String encryptedDateStr = HexByteUtil.byteArr2HexStr(AuthRSAUtils.encryptByPrivateKey(data, privateKey));
        return encryptedDateStr;
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return AuthBase64Utils.encode(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return AuthBase64Utils.encode(key.getEncoded());
    }
}

